#ifndef UDP_TCL_H
#define UDP_TCL_H
static char udp_tcl_h_RCS[] = "$Id: udp_tcl.h,v 1.1.1.1 1997/05/15 21:02:59 millerms Exp $";
/*
 *----------------------------------------------------------------------
 *	AUTHOR:        	Michael Miller - msmiller@acm.org
 *----------------------------------------------------------------------
 * udp API
 */
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <limits.h>

int udp_open(short localport);
int udp_recv(int fd, char **r_host, short *r_port, void **message, int *size);
int udp_send(int fd, char *r_host, short r_port, void *message, int buf_size);

extern char udp_error[256];

/*
 *----------------------------------------------------------------------
 * TCL API
 */
#include "tcl.h"

/*
 * for Tcl_channel
 */
typedef struct {
	Tcl_File sock;
	char remotehost[256];
	short remoteport;
}UDP_state;

#endif
