%
% TkGraphicIntro.T
%
\documentstyle{article}

\newcommand{\tclVogle}{{\rm tcl}{\sc Vogle}}
\newcommand{\Vogle}{{\sc Vogle}}
\newcommand{\Tk}{{\sc Tk}}
\newcommand{\TkGraphic}{{\sc TkGraphic}}
\newcommand{\Tcl}{{\sc Tcl}}
\newcommand{\PHIGS}{{\sc PHIGS}}
\newcommand{\CLang}{{\sf C}}

\begin{document} % start document
\title{
    A \Tk\ graphic widget and \Tcl\ extension set 
    for the \Vogle\ graphics library 
}
\author{Mike Hoegeman}
\maketitle

\parindent 0pt
\parskip 14pt

\section{Suggested reading}

    The user should first read at least the introductory usenix papers
    on \Tk\ X11 toolkit and \Tcl\ embeddable command language before
    reading this document. They are present in the \Tcl\ and \Tk\ source
    distributions.

    Before reading this document you should familiarize yourself with
    The \Tk/Tcl\ X11 toolkit. The usenix papers on \Tk\ and \Tcl\ are
    available in the \Tk\ and \Tcl\ source code distributions are a good
    start. 
    
    If you are not familiar with computer graphics jargon. The
    publication 'An Introduction to Computer Graphics concepts'
    produced by Sun Microsystems is a simple introduction to the
    many of the terms used in this documentation. It is published by
    Addison-Wesley and has the ISBN number \mbox{[ ISBN 0-201-56789-X ]}

\section{Introduction}

    This document describes a graphics widget for the \Tk\ X11 toolkit
    and an accompanying set of \Tcl\ commands (collectively called
    \tclVogle\ ) for rendering graphics within these widgets.

    \tclVogle\ is a set of \Tcl\ extensions which, for the most part, map
    directly to \CLang\ functions within the \Vogle\ graphics library.

\section{\Vogle}

    \Vogle\  is graphics library similar in functionality to Silicon
    Graphics' GL graphics library. It provides functions for doing
    basic graphics operations such as line drawing, curve drawing,
    polygon fills and stroking in 2 and 3 dimensions. It also has
    notions of transformation matrice, graphics context, and viewport
    stacks.

    \Vogle\ is a `mixed mode' style graphics library into which output
    devices can easily be plugged into. It has facilities for doing
    both immediate mode graphics operations as well as the ability to
    build moderately complex hierarchical display objects which can
    then be rendered by `calling' them. The object capabilities are not
    as elaborate as \PHIGS\ for example, but are still very useful for
    cases where display-list style graphics rendering is desireable.

    Support for software Hershey stroke fonts is present for things
    like rotation and scaling of text.  Access to device resident fonts
    is also available when text rendering speed is needed and simpler
    text orientation is all that is required. Double buffering of
    drawing is also supported if the output device has facilities for
    it. For example, in X11 based devices, it is usually done via the use
    of offscreen X11 pixmaps.

\section{\Tk\ graphic widgets}

    The \Tk\ graphic widgets are implemented as a \Vogle\ pseudo device
    resident at the bottom layer of \Vogle\/'s software architecture.
    There are other software psuedo devices supported by the
    \Vogle\ library such as PostScript and HPGL. \Tk\ graphics widgets
    are just another type of psuedo device to \Vogle\ . As a result,
    the integration of the \Tk\ graphics widget with \Vogle\ library is
    a seamless and coherent one.  Below is a figure depicting how the
    \tclVogle\ , \Vogle\ \CLang\ library, and \Tk\ graphic widget software
    modules interact

\begin{verbatim}

                             application
                           tclVogle  / Tcl 
                      Vogle C library API Level
                     Vogle  software device level 
                  tkGraphic / postscript / HPGL / etc...
                    Tk         disk 	   disk
                   Xlib 
                ==network==
                  X Server 
             CRT / mouse / keyboard

\end{verbatim}

    Enough talk for now, it's time for an example to show you
    how \Tk\ graphic widgets work. 

\section{A simple example of a \Tk\ Graphic widget}
    
    Here is a simple \Tk\/\Tcl\ script that draws "Hello world!"
    centered in the widget.

%%verbatim helloWorld.t

    The first half of the script defines a \Tcl\ function called
    helloWorld. helloWorld contains all the \tclVogle\ graphics commands
    we want drawn within the \Tk\ graphics widget. The second half sets
    up the top level window and the creates a \Tk\ graphics widget
    called {\it .top}. The
	\begin{verbatim}
	    -command { helloWorld }
	\end{verbatim}
    configuration option for {\it .top} defines a \Tcl\ fragment that
    is to be run by the \Tk\ toolkit whenever {\it .top} needs
    repainting., In this case the fragment is \{ helloWorld .top \}. 
    The helloWorld \tclVogle\ procedure is straightforward.

    \begin{verbatim}
		g_color white g_clear
    \end{verbatim}

    Sets the drawing color to white and then floods the widget with
    that color

    \begin{verbatim}
		g_move 0.0 0.0
		g_color black
    \end{verbatim}

    Moves to the center of the widget and sets the drawing color
    to black.

    \begin{verbatim}
		g_centertext true
		g_drawstr "Hello World!"
    \end{verbatim}

    Designates text drawing is to be centered and draws the
    hello world string. 

    This example should be in a file called "helloWorld.t" in the eg/
    directory of the \tclVogle\ source package

    You can try running the example by typing

    \begin{verbatim}
		% wish -file helloWorld.t &
    \end{verbatim}

    Your \tclVogle\ interpreter may not be called wish. Ask the person
    who installed \tclVogle\ what the name of the interpreter is if
    this is the case and use that name instead of wish.

\section{Widget configuration options}
    The graphic widget has all the configuration options that are
    present in the \Tk\ frame widget. In addition the following options
    are available.

\subsection{The -font option for graphic widgets}
    the -font option for a graphic widget in effect defines the vogle
    hardware font "small" for the \Vogle\ software device associated
    with the graphic widget

\subsection{The -command option for graphic widgets}
    The {\tt -command} option for a graphic widget defines a callback which 
    is performed whenever the graphic widget is damaged.

    Whenever a graphic needs repainting (due to damage). The following
    will occur

    \begin{itemize}
    \item a automatic {\tt g\_init} {\it graphicName} will be performed
    \item The tcl fragment supplied with the -command will then be executed
    \item If a border was specified for the widget it is painted.
    \end{itemize}

    If no -command is specified for the widget it is repainted in the same
    way as a {\bf frame} widget.

\section{Widget commands}
    The graphic widget has the configure option like all other
    \Tk\ widgets. In also has the following additional commands.

\subsection{The paint widget command for graphic widgets}
    The paint widget command for graphics are for those times when you
    want to paint things on a graphic directly. In these cases, a
    graphic command {\tt paint} can be called like so

    .{\it graphicName} paint {\tt?tclFragment?}

    If no {\tt tclFragment} is supplied any fragment previously
    supplied via the -command option is used as a default. This allows
    you to change the -command option an repaint the screen immediately
    to reflect the new -command.

    Here is an example using the paint directive to do a technicolor 
    visial bell of a graphic widget

    \begin{verbatim}
	# flash some colors
	.top paint {
	    foreach c {black red green blue yellow white} {
		g_color $c
		g_clear
		after 10
	    }
	}
	# pause 1 second
	after 100

	# then paint it back the way it was using the hello world fragment
	# defined earlier via the -command config option for .top
	.top paint
    \end{verbatim}

\section{coordinate systems in a \Tk\ graphic widget}
    
    As is apparent from the example above, the graphic widget by default uses
    the \Vogle\ screen coordinate system of 
    
    \begin{quote}
	    -1.0 $\leftarrow x \rightarrow$ 1.0

	    -1.0 $\leftarrow y \rightarrow$ 1.0
    \end{quote}

    Unlike X11, the y coordinate system increases from the bottom of the
    screen to the top. So the point x = 1.0, y = 1.0 is the upper right
    corner of the widget and not the lower right corner.

    If the widget is resized. The widget's screen coordinates are
    automatically resized to reflect this. So no matter how you stretch
    the window in the helloWorld example, the text will always appear
    centered in the widget.


\subsection{Drawing in units of pixels}

    Drawing in screen coordinates is not always convenient. Many times it
    is preferable to draw with a constant scale no matter what size the
    widget is resized to. Below is an example of how to scale the world
    coordinate system for a widget prior to drawing such that 1 unit
    in world coordinates equals 1 pixel

%%verbatim pixelCoords.t

    In this example, a short and wide rectangle is stroked on a black
    background.

    The portion of interest though is 

    \begin{verbatim}
	g_translate -1 -1 
	g_scale [expr 2.0/[winfo width $w]] [expr 2.0/[winfo height $w]]
    \end{verbatim}


    The g\_translate set's our origin to the lower left corner of the widget.
    The g\_scale then scales the world up to units of pixels.

    The above example turns to be overkill because we can accomplish the same
    task of converting to 1 world unit to 1 pixel one fell swoop with the 
    {\tt g\_ortho} command like this

%%verbatim orthoPixelCoords.t

    For those who are not too comfortable \Tcl\ and it's \Tk\ X11
    Toolkit extensions, the \Tk\ {\it winfo} command lets you extract
    basic X window information from a widget, in this case the width
    and height. In Tcl, enclosing brackets act vaguely like enclosing
    back quotes in the shell. Expr acts much like the {\it sh's} {\tt expr} 
    command. A \CLang\ style psuedo-coding of the g\_scale line
    would be something like this

    \begin{verbatim}

	extern void g_scale(float x, float y);
	extern int  winfo(char *attributename, Widget widg);
	WidgetType  w;

	g_scale( 2.0 / (float) winfo("width", w) , 
	         2.0 / (float) winfo("height", w) );

    \end{verbatim}

    If you run this example, You'll see that the rectangle stays a
    constant size and position in the widget and that the units are in
    pixels no matter how the widget is resized.

\subsection{The -squareaspect widget attribute}

    You've might have noticed a widget creation attribute not in the
    previous example.

    \begin{verbatim}
    	-squareaspect false
    \end{verbatim}

    This configuration attribute tells the widget to set the
    \Vogle\ software device aspect ratio to be the that of it's
    associated widget instead of being 1 (square). Square is the
    default.

    This simplifies our transformation setup. With a square aspect
    ratio you need to figure out the minimum of the widget width and
    height and then scale using that minimum in both the x and y
    dimensions.  With an aspect ratio equal to the widget dimensions
    you can using the widget width and height directly.  In addition,
    an aspect which is square causes the longer dimension to be clipped
    to match the shorter one.  A non square aspect lets us draw in the
    whole widget without having to invoke additional
    \tclVogle\ commands to widen the widgets viewport.


\end{document}
