proc echo {args} {foreach argument $args {puts -nonewline "$argument "}
puts ""}
catch {rename proc ::proc}
if {[llength [info commands new]]==0} {if {![info exists _newId]} {set _newId 0}
::proc new {classOrId args} {
    global _newId _class
    if {[catch {expr $classOrId}]} {
        set _class([set id [incr _newId]]) $classOrId
        eval $classOrId::$classOrId $id $args
    } else {
        [set _class([set id [incr _newId]]) $_class($classOrId)]::_copy $id $classOrId
    }
    return $id
}
::proc delete {args} {
    global _class
    foreach id $args {
        _delete $_class($id) $id
        unset _class($id)
    }
}
::proc _delete {class id} {
    $class::~$class $id
    global $class
    foreach name [array names $class $id,*] {
        unset ${class}($name)
    }
}
::proc classof {id} {
    global _class
    return $_class($id)
}
::proc _copy {class from to} {
    global $class
    set index [string length $from]
    foreach name [array names $class $from,*] {
        set ${class}($to[string range $name $index end]) [set ${class}($name)]
    }
    set index [string length $class$from]
    foreach name [info globals $class$from*] {
        global [set target $class$to[string range $name $index end]] $name
        array set $target [array get $name]
    }
}}
::proc virtual {keyword name arguments args} {
    if {[string compare $keyword proc]!=0} {
        error "virtual operator works only on proc, not $keyword"
    }
    if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
        error "$name is not a valid member procedure name"
    }
    if {[string compare $class $procedure]==0} {
        error "cannot make class $class constructor virtual"
    }
    if {[string compare ~$class $procedure]==0} {
        error "cannot make class $class destructor virtual"
    }
    if {[string compare [lindex $arguments 0] this]!=0} {
        error "cannot make static procedure $procedure of class $class virtual"
    }
    global _pureVirtual
    set _pureVirtual [expr [llength $args]==0]
    proc $name $arguments [lindex $args 0]
    unset _pureVirtual
}
::proc proc {name arguments args} {
    global _baseClasses
    if {![regexp {^(.+)::(.+)$} $name dummy class procedure]} {
        ::proc $name $arguments [lindex $args 0]
        return
    }
    if {[llength $args]==0} {
        error "missing body for $name"
    }
    if {[string compare $class $procedure]==0} {
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class constructor first argument must be this"
        }
        if {[string compare [lindex $arguments 1] copy]==0} {
            if {[llength $arguments]!=2} {
                error "class $class copy constructor must have 2 arguments exactly"
            }
            if {[catch {info body $class::$class}]} {
                error "class $class copy constructor defined before constructor"
            }
            eval _constructorDeclaration $class 1 \{$arguments\} $args
        } else {
            eval _constructorDeclaration $class 0 \{$arguments\} $args
            _generateDefaultCopyConstructor $class
        }
    } elseif {[string compare ~$class $procedure]==0} {
        if {[llength $arguments]!=1} {
            error "class $class destructor must have 1 argument exactly"
        }
        if {[string compare [lindex $arguments 0] this]!=0} {
            error "class $class destructor argument must be this"
        }
        if {[catch {info body $class::$class}]} {
            error "class $class destructor defined before constructor"
        }
        _destructorDeclaration $class $arguments [lindex $args 0]
    } else {
        _memberProcedureDeclaration $class $procedure $arguments [lindex $args 0]
    }
}
::proc _ancestors {class} {
    global _baseClasses
    if {![info exists _baseClasses($class)]} {
        return {}
    }
    foreach base [set ancestors $_baseClasses($class)] {
        foreach class [_ancestors $base] {
            if {[lsearch -exact $ancestors $class]<0} {
                lappend ancestors $class
            }
        }
    }
    return $ancestors
}
::proc _constructorDeclaration {class copy arguments args} {
    global _baseClasses
    set number [expr [llength $args]-1]
    if {($number%2)!=0} {
        error "bad $class constructor declaration, a base class, contructor arguments or body may be missing"
    }
    for {set index 0} {$index<$number} {incr index} {
        set base [lindex $args $index]
        if {!$copy} {
            if {[info exists _baseClasses($class)]&&([lsearch -exact $_baseClasses($class) $base]>=0)} {
                error "class $class directly inherits from class $base more than once"
            }
            lappend _baseClasses($class) $base
        }
        regsub -all \n [lindex $args [incr index]] {} constructorArguments($base)
    }
    set body [lindex $args $index]
    if {[info exists _baseClasses($class)]} {
        foreach base $_baseClasses($class) {
            if {[string compare $class $base]==0} {
                error "class $class cannot be derived from itself"
            }
            if {[catch {info body $base::$base}]} {
                error "class $class constructor defined before base class $base constructor"
            }
        }
        set constructorBody  "
global [_ancestors $class] $class
"
        if {[string compare [lindex $arguments end] args]==0} {
            foreach base $_baseClasses($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                if {[string compare [lindex $constructorArguments($base) end] \$args]==0} {
                    append constructorBody  "set ${base}(\$this,_derived) $class
eval $base::$base \$this {[lrange $constructorArguments($base) 0 [expr [llength $constructorArguments($base)]-2]]} \$args
"
                } else {
                    append constructorBody  "set ${base}(\$this,_derived) $class
$base::$base \$this $constructorArguments($base)
"
                }
            }
        } else {
            foreach base $_baseClasses($class) {
                if {![info exists constructorArguments($base)]} {
                    error "missing base class $base constructor arguments from class $class constructor"
                }
                append constructorBody  "set ${base}(\$this,_derived) $class
$base::$base \$this $constructorArguments($base)
"
            }
        }
    } else {
        set constructorBody  "
global $class
"
    }
    if {$copy} {
        append constructorBody  "catch {set ${class}(\$this,_derived) \[set ${class}(\$[lindex $arguments 1],_derived)\]}
"
    }
    append constructorBody $body
    if {$copy} {
        ::proc $class::_copy $arguments $constructorBody
    } else {
        ::proc $class::$class $arguments $constructorBody
    }
}
::proc _destructorDeclaration {class arguments body} {
    global _baseClasses
    set body  "
global [_ancestors $class] $class
$body
"
    if {[info exists _baseClasses($class)]} {
        for {set index [expr [llength $_baseClasses($class)]-1]} {$index>=0} {incr index -1} {
            set base [lindex $_baseClasses($class) $index]
            append body  "_delete $base \$this
"
        }
    }
    ::proc $class::~$class $arguments $body
}
::proc _memberProcedureDeclaration {class name arguments body} {
    global _pureVirtual
    if {[info exists _pureVirtual]} {
        if {$_pureVirtual} {
            ::proc $class::$name $arguments  "
global [_ancestors $class] $class
eval \$${class}(\$this,_derived)::$name \[lrange \[info level 0\] 1 end\]
"
        } else {
            ::proc ::$class::$name $arguments  "
global [_ancestors $class] $class
$body
"
            ::proc $class::$name $arguments  "
global [_ancestors $class] $class
if {!\[catch {info body \$${class}(\$this,_derived)::$name}\]} {
return \[eval \$${class}(\$this,_derived)::$name \[lrange \[info level 0\] 1 end\]\]
}
eval ::\[info level 0\]
"
        }
    } else {
        ::proc $class::$name $arguments  "
global [_ancestors $class] $class
$body
"
    }
}
::proc _generateDefaultCopyConstructor {class} {
    global _baseClasses
    if {[info exists _baseClasses($class)]} {
        foreach base $_baseClasses($class) {
            append body  "$base::_copy \$this \$sibling
"
        }
    }
    append body  "_copy $class \$sibling \$this
"
    ::proc $class::_copy {this sibling} $body
}
set PI 3.14159265358979323846
proc maximum {a b} {return [expr $a>$b?$a:$b]}
proc minimum {a b} {return [expr $a<$b?$a:$b]}
proc normalizedAngle {value} {while {$value>=180} {set value [expr $value-360]}
while {$value<-180} {set value [expr $value+360]}
return $value}
proc slice::slice {this canvas x y radiusX radiusY start extent args} {array set option {-height 0 -topcolor {} -bottomcolor {}}
array set option $args
set slice($this,canvas) $canvas
set slice($this,start) 0
set slice($this,radiusX) $radiusX
set slice($this,radiusY) $radiusY
set slice($this,height) $option(-height)
set slice($this,origin) [$canvas create line -$radiusX -$radiusY -$radiusX -$radiusY -fill {} -tags slice($this)]
if {$option(-height)>0} {set slice($this,startBottomArcFill) [$canvas create arc 0 0 0 0 -style chord -extent 0 -fill $option(-bottomcolor) -outline $option(-bottomcolor) -tags slice($this)]
set slice($this,startPolygon) [$canvas create polygon 0 0 0 0 0 0 -fill $option(-bottomcolor) -tags slice($this)]
set slice($this,startBottomArc) [$canvas create arc 0 0 0 0 -style arc -extent 0 -fill black -tags slice($this)]
set slice($this,endBottomArcFill) [$canvas create arc 0 0 0 0 -style chord -extent 0 -fill $option(-bottomcolor) -outline $option(-bottomcolor) -tags slice($this)]
set slice($this,endPolygon) [$canvas create polygon 0 0 0 0 0 0 -fill $option(-bottomcolor) -tags slice($this)]
set slice($this,endBottomArc) [$canvas create arc 0 0 0 0 -style arc -extent 0 -fill black -tags slice($this)]
set slice($this,startLeftLine) [$canvas create line 0 0 0 0 -tags slice($this)]
set slice($this,startRightLine) [$canvas create line 0 0 0 0 -tags slice($this)]
set slice($this,endLeftLine) [$canvas create line 0 0 0 0 -tags slice($this)]
set slice($this,endRightLine) [$canvas create line 0 0 0 0 -tags slice($this)]}
set slice($this,topArc) [$canvas create arc -$radiusX -$radiusY $radiusX $radiusY -extent $extent -fill $option(-topcolor) -tags slice($this)]
$canvas move slice($this) [expr $x+$radiusX] [expr $y+$radiusY]
slice::update $this $start $extent}
proc slice::~slice {this} {$slice($this,canvas) delete slice($this)}
proc slice::update {this start extent} {set canvas $slice($this,canvas)
set coordinates [$canvas coords slice($this)]
set radiusX $slice($this,radiusX)
set radiusY $slice($this,radiusY)
$canvas coords $slice($this,origin) -$radiusX -$radiusY $radiusX $radiusY
$canvas coords $slice($this,topArc) -$radiusX -$radiusY $radiusX $radiusY
set extent [maximum 0 $extent]
if {$extent>=360} {set extent 359.9999999999999}
$canvas itemconfigure $slice($this,topArc) -start [set slice($this,start) [normalizedAngle $start]] -extent [set slice($this,extent) $extent]
if {$slice($this,height)>0} {slice::updateBottom $this}
$canvas move slice($this) [expr [lindex $coordinates 0]+$radiusX] [expr [lindex $coordinates 1]+$radiusY]}
proc slice::updateBottom {this} {global PI
set start $slice($this,start)
set extent $slice($this,extent)
set canvas $slice($this,canvas)
set radiusX $slice($this,radiusX)
set radiusY $slice($this,radiusY)
set height $slice($this,height)
$canvas itemconfigure $slice($this,startBottomArcFill) -extent 0
$canvas coords $slice($this,startBottomArcFill) -$radiusX -$radiusY $radiusX $radiusY
$canvas move $slice($this,startBottomArcFill) 0 $height
$canvas itemconfigure $slice($this,startBottomArc) -extent 0
$canvas coords $slice($this,startBottomArc) -$radiusX -$radiusY $radiusX $radiusY
$canvas move $slice($this,startBottomArc) 0 $height
$canvas coords $slice($this,startLeftLine) 0 0 0 0
$canvas coords $slice($this,startRightLine) 0 0 0 0
$canvas itemconfigure $slice($this,endBottomArcFill) -extent 0
$canvas coords $slice($this,endBottomArcFill) -$radiusX -$radiusY $radiusX $radiusY
$canvas move $slice($this,endBottomArcFill) 0 $height
$canvas itemconfigure $slice($this,endBottomArc) -extent 0
$canvas coords $slice($this,endBottomArc) -$radiusX -$radiusY $radiusX $radiusY
$canvas move $slice($this,endBottomArc) 0 $height
$canvas coords $slice($this,endLeftLine) 0 0 0 0
$canvas coords $slice($this,endRightLine) 0 0 0 0
$canvas coords $slice($this,startPolygon) 0 0 0 0 0 0 0 0
$canvas coords $slice($this,endPolygon) 0 0 0 0 0 0 0 0
set startX [expr $radiusX*cos($start*$PI/180)]
set startY [expr -$radiusY*sin($start*$PI/180)]
set end [normalizedAngle [expr $start+$extent]]
set endX [expr $radiusX*cos($end*$PI/180)]
set endY [expr -$radiusY*sin($end*$PI/180)]
set startBottom [expr $startY+$height]
set endBottom [expr $endY+$height]
if {(($start>=0)&&($end>=0))||(($start<0)&&($end<0))} {if {$extent<=180} {if {$start<0} {$canvas itemconfigure $slice($this,startBottomArcFill) -start $start -extent $extent
$canvas itemconfigure $slice($this,startBottomArc) -start $start -extent $extent
$canvas coords $slice($this,startPolygon) $startX $startY $endX $endY $endX $endBottom $startX $startBottom
$canvas coords $slice($this,startLeftLine) $startX $startY $startX $startBottom
$canvas coords $slice($this,startRightLine) $endX $endY $endX $endBottom}} else {if {$start<0} {$canvas itemconfigure $slice($this,startBottomArcFill) -start 0 -extent $start
$canvas itemconfigure $slice($this,startBottomArc) -start 0 -extent $start
$canvas coords $slice($this,startPolygon) $startX $startY $radiusX 0 $radiusX $height $startX $startBottom
$canvas coords $slice($this,startLeftLine) $startX $startY $startX $startBottom
$canvas coords $slice($this,startRightLine) $radiusX 0 $radiusX $height
set bottomArcExtent [expr $end+180]
$canvas itemconfigure $slice($this,endBottomArcFill) -start -180 -extent $bottomArcExtent
$canvas itemconfigure $slice($this,endBottomArc) -start -180 -extent $bottomArcExtent
$canvas coords $slice($this,endPolygon) -$radiusX 0 $endX $endY $endX $endBottom -$radiusX $height
$canvas coords $slice($this,endLeftLine) -$radiusX 0 -$radiusX $height
$canvas coords $slice($this,endRightLine) $endX $endY $endX $endBottom} else {$canvas itemconfigure $slice($this,startBottomArcFill) -start 0 -extent -180
$canvas itemconfigure $slice($this,startBottomArc) -start 0 -extent -180
$canvas coords $slice($this,startPolygon) -$radiusX 0 $radiusX 0 $radiusX $height -$radiusX $height
$canvas coords $slice($this,startLeftLine) -$radiusX 0 -$radiusX $height
$canvas coords $slice($this,startRightLine) $radiusX 0 $radiusX $height}}} else {if {$start<0} {$canvas itemconfigure $slice($this,startBottomArcFill) -start 0 -extent $start
$canvas itemconfigure $slice($this,startBottomArc) -start 0 -extent $start
$canvas coords $slice($this,startPolygon) $startX $startY $radiusX 0 $radiusX $height $startX $startBottom
$canvas coords $slice($this,startLeftLine) $startX $startY $startX $startBottom
$canvas coords $slice($this,startRightLine) $radiusX 0 $radiusX $height} else {set bottomArcExtent [expr $end+180]
$canvas itemconfigure $slice($this,endBottomArcFill) -start -180 -extent $bottomArcExtent
$canvas itemconfigure $slice($this,endBottomArc) -start -180 -extent $bottomArcExtent
$canvas coords $slice($this,endPolygon) -$radiusX 0 $endX $endY $endX $endBottom -$radiusX $height
$canvas coords $slice($this,startLeftLine) -$radiusX 0 -$radiusX $height
$canvas coords $slice($this,startRightLine) $endX $endY $endX $endBottom}}}
proc slice::position {this start} {slice::update $this $start $slice($this,extent)}
proc slice::rotate {this angle} {if {$angle!=0} {slice::update $this [expr $slice($this,start)+$angle] $slice($this,extent)}}
proc slice::size {this extent} {slice::update $this $slice($this,start) $extent}
proc slice::data {this arrayName} {upvar $arrayName data
set data(start) $slice($this,start)
set data(extent) $slice($this,extent)
set data(xRadius) $slice($this,radiusX)
set data(yRadius) $slice($this,radiusY)
set coordinates [$slice($this,canvas) coords $slice($this,origin)]
set data(xCenter) [expr [lindex $coordinates 0]+$data(xRadius)]
set data(yCenter) [expr [lindex $coordinates 1]+$data(yRadius)]
set data(height) $slice($this,height)}
proc pieLabeller::pieLabeller {this canvas args} {array set option {-offset 5}
array set option $args
set pieLabeller($this,offset) [winfo fpixels $canvas $option(-offset)]
catch {set pieLabeller($this,font) $option(-font)}
set pieLabeller($this,canvas) $canvas}
proc pieLabeller::~pieLabeller {this} {}
proc pieLabeller::bind {this pieId} {set pieLabeller($this,pieId) $pieId}
virtual proc pieLabeller::create {this sliceId args}
virtual proc pieLabeller::update {this label value}
virtual proc pieLabeller::rotate {this label}
proc canvasLabel::canvasLabel {this canvas x y args} {set canvasLabel($this,canvas) $canvas
set canvasLabel($this,origin) [$canvas create line $x $y $x $y -fill {} -tags canvasLabel($this)]
set canvasLabel($this,rectangle) [$canvas create rectangle 0 0 0 0 -tags canvasLabel($this)]
set canvasLabel($this,text) [$canvas create text 0 0 -tags canvasLabel($this)]
array set options {-anchor center -style box -padding 2 -bulletwidth 20}
array set options $args
eval canvasLabel::configure $this [array get options]}
proc canvasLabel::~canvasLabel {this} {$canvasLabel($this,canvas) delete canvasLabel($this)}
proc canvasLabel::configure {this args} {set update 0
array set value $args
foreach option [array names value] {switch -- $option {-background {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,rectangle) -fill $value($option)
            }
-foreground {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,text) -fill $value($option)
            }
-borderwidth {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,rectangle) -width $value($option)
                set update 1
            }
-stipple {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,rectangle) $option $value($option)
            }
-anchor {
                set canvasLabel($this,anchor) $value($option)
                set update 1
            }
-font -
-justify -
-text -
-width {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,text) $option $value($option)
                set update 1
            }
-bordercolor {
                $canvasLabel($this,canvas) itemconfigure $canvasLabel($this,rectangle) -outline $value($option)
            }
-style {
                set canvasLabel($this,style) $value($option)
                set update 1
            }
-padding {
                set canvasLabel($this,padding) [winfo fpixels $canvasLabel($this,canvas) $value($option)]
                set update 1
            }
-bulletwidth {
                set canvasLabel($this,bulletWidth) [winfo fpixels $canvasLabel($this,canvas) $value($option)]
                set update 1
            }}}
if {$update} {canvasLabel::update $this}}
proc canvasLabel::cget {this option} {switch -- $option {-background {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,rectangle) -fill]
        }
-foreground {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,text) -fill]
        }
-borderwidth {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,rectangle) -width]
        }
-stipple {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,rectangle) $option]
        }
-anchor {
            return $canvasLabel($this,anchor)
        }
-font -
-justify -
-text -
-width {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,text) $option]
        }
-bordercolor {
            return [$canvasLabel($this,canvas) itemcget $canvasLabel($this,rectangle) -outline]
        }
-style {
            return $canvasLabel($this,style)
        }
-padding {
            return $canvasLabel($this,padding)
        }
-bulletwidth {
            return $canvasLabel($this,bulletWidth)
        }}}
proc canvasLabel::update {this} {set canvas $canvasLabel($this,canvas)
set rectangle $canvasLabel($this,rectangle)
set text $canvasLabel($this,text)
set coordinates [$canvas coords $canvasLabel($this,origin)]
set x [lindex $coordinates 0]
set y [lindex $coordinates 1]
set border [$canvas itemcget $rectangle -width]
set textBox [$canvas bbox $text]
if {[string compare $canvasLabel($this,style) split]==0} {set textHeight [expr [lindex $textBox 3]-[lindex $textBox 1]]
set rectangleWidth $canvasLabel($this,bulletWidth)
set halfWidth [expr ($rectangleWidth+$canvasLabel($this,padding)+([lindex $textBox 2]-[lindex $textBox 0]))/2.0]
set halfHeight [expr ($textHeight/2.0)+$border]
$canvas coords $rectangle [expr $x-$halfWidth] [expr $y-$halfHeight] [expr $x-$halfWidth+$rectangleWidth] [expr $y+$halfHeight]
$canvas coords $text [expr $x+(($rectangleWidth+$canvasLabel($this,padding))/2.0)] $y} else {set halfWidth [expr $border+$canvasLabel($this,padding)+(([lindex $textBox 2]-[lindex $textBox 0])/2.0)]
set halfHeight [expr $border+$canvasLabel($this,padding)+(([lindex $textBox 3]-[lindex $textBox 1])/2.0)]
$canvas coords $rectangle [expr $x-$halfWidth] [expr $y-$halfHeight] [expr $x+$halfWidth] [expr $y+$halfHeight]
$canvas coords $text $x $y}
set anchor $canvasLabel($this,anchor)
set xDelta [expr ([string match *w $anchor]-[string match *e $anchor])*$halfWidth]
set yDelta [expr ([string match n* $anchor]-[string match s* $anchor])*$halfHeight]
$canvas move $rectangle $xDelta $yDelta
$canvas move $text $xDelta $yDelta}
proc canvasLabelsArray::canvasLabelsArray {this canvas x y width args} {set canvasLabelsArray($this,canvas) $canvas
set canvasLabelsArray($this,width) [winfo fpixels $canvas $width]
set canvasLabelsArray($this,origin) [$canvas create line $x $y $x $y -fill {} -tags canvasLabelsArray($this)]
array set options {-justify left -style box -bulletwidth 20}
array set options $args
set canvasLabelsArray($this,options) [array get options]}
proc canvasLabelsArray::~canvasLabelsArray {this} {foreach label $canvasLabelsArray($this,labelIds) {delete $label}
$canvasLabelsArray($this,canvas) delete canvasLabelsArray($this)}
proc canvasLabelsArray::create {this args} {array set options $canvasLabelsArray($this,options)
array set options $args
set labelId [eval new canvasLabel $canvasLabelsArray($this,canvas) 0 0 [array get options]]
$canvasLabelsArray($this,canvas) addtag canvasLabelsArray($this) withtag canvasLabel($labelId)
lappend canvasLabelsArray($this,labelIds) $labelId
canvasLabelsArray::position $this $labelId $options(-justify)
return $labelId}
proc canvasLabelsArray::position {this labelId justification} {set canvas $canvasLabelsArray($this,canvas)
set coordinates [$canvas coords $canvasLabelsArray($this,origin)]
set x [lindex $coordinates 0]
set y [lindex $coordinates 1]
set coordinates [$canvas bbox canvasLabel($labelId)]
set labelHeight [expr [lindex $coordinates 3]-[lindex $coordinates 1]]
set index [expr [llength $canvasLabelsArray($this,labelIds)]-1]
switch $justification {
        left {
            set x [expr $x+(($index%2)*($canvasLabelsArray($this,width)/2.0))]
            set anchor nw
        }
        right {
            set x [expr $x+((($index%2)+1)*($canvasLabelsArray($this,width)/2.0))]
            set anchor ne
        }
        default {
            set x [expr $x+((1.0+(2*($index%2)))*$canvasLabelsArray($this,width)/4)]
            set anchor n
        }
    }
canvasLabel::configure $labelId -anchor $anchor
$canvas move canvasLabel($labelId) $x [expr $y+(($index/2)*$labelHeight)]}
proc pieBoxLabeller::pieBoxLabeller {this canvas args} pieLabeller {$canvas $args} {
    array set option {-justify left}
    array set option $args
    set pieBoxLabeller($this,justify) $option(-justify)
}
proc pieBoxLabeller::~pieBoxLabeller {this} {catch {delete $pieBoxLabeller($this,array)}}
proc pieBoxLabeller::create {this sliceId args} {if {![info exists pieBoxLabeller($this,array)]} {set options "-justify $pieBoxLabeller($this,justify)"
catch {lappend options -font $pieLabeller($this,font)}
set box [$pieLabeller($this,canvas) bbox pie($pieLabeller($this,pieId))]
set pieBoxLabeller($this,array) [eval new canvasLabelsArray $pieLabeller($this,canvas) [lindex $box 0] [expr [lindex $box 3]+$pieLabeller($this,offset)] [expr [lindex $box 2]-[lindex $box 0]] $options]}
set labelId [eval canvasLabelsArray::create $pieBoxLabeller($this,array) $args]
$pieLabeller($this,canvas) addtag pieLabeller($this) withtag canvasLabelsArray($pieBoxLabeller($this,array))
canvasLabel::configure $labelId -text [canvasLabel::cget $labelId -text]:
return $labelId}
proc pieBoxLabeller::update {this labelId value} {regsub {:.*$} [canvasLabel::cget $labelId -text] ": $value" text
canvasLabel::configure $labelId -text $text}
proc pieBoxLabeller::rotate {this labelId} {}
proc pie::pie {this canvas x y width height args} {array set option { -thickness 0 -background {} -title {} -titlefont {} -titleoffset 2 -colors {#7FFFFF #7FFF7F #FF7F7F #FFFF7F #7F7FFF #FFBF00 #BFBFBF #FF7FFF #FFFFFF} }
array set option $args
set pie($this,canvas) $canvas
if {[info exists option(-labeller)]} {set pie($this,labellerId) $option(-labeller)} else {set pie($this,labellerId) [new pieBoxLabeller $canvas]}
$canvas addtag pie($this) withtag pieLabeller($pie($this,labellerId))
pieLabeller::bind $pie($this,labellerId) $this
set pie($this,radiusX) [expr [winfo fpixels $canvas $width]/2.0]
set pie($this,radiusY) [expr [winfo fpixels $canvas $height]/2.0]
set pie($this,thickness) [winfo fpixels $canvas $option(-thickness)]
if {[string length $option(-background)]>0} {set bottomColor [tkDarken $option(-background) 60]} else {set bottomColor {}}
set pie($this,backgroundSliceId) [new slice $canvas [winfo fpixels $canvas $x] [winfo fpixels $canvas $y] $pie($this,radiusX) $pie($this,radiusY) 90 360 -height $pie($this,thickness) -topcolor $option(-background) -bottomcolor $bottomColor]
$canvas addtag pie($this) withtag slice($pie($this,backgroundSliceId))
$canvas addtag pieGraphics($this) withtag slice($pie($this,backgroundSliceId))
set pie($this,sliceIds) {}
set pie($this,colors) $option(-colors)
pie::createTitle $this $option(-title) $option(-titlefont) [winfo fpixels $canvas $option(-titleoffset)]}
proc pie::~pie {this} {delete $pie($this,labellerId)
foreach sliceId $pie($this,sliceIds) {delete $sliceId}
delete $pie($this,backgroundSliceId)}
proc pie::newSlice {this {text {}}} {global slice
set start 90
foreach sliceId $pie($this,sliceIds) {set start [expr $start-$slice($sliceId,extent)]}
set color [lindex $pie($this,colors) [expr [llength $pie($this,sliceIds)]%[llength $pie($this,colors)]]]
set numberOfSlices [llength $pie($this,sliceIds)]
set coordinates [$pie($this,canvas) coords slice($pie($this,backgroundSliceId))]
set sliceId [new slice $pie($this,canvas) [lindex $coordinates 0] [lindex $coordinates 1] $pie($this,radiusX) $pie($this,radiusY) $start 0 -height $pie($this,thickness) -topcolor $color -bottomcolor [tkDarken $color 60]]
$pie($this,canvas) addtag pie($this) withtag slice($sliceId)
$pie($this,canvas) addtag pieGraphics($this) withtag slice($sliceId)
lappend pie($this,sliceIds) $sliceId
if {[string length $text]==0} {set text "slice [llength $pie($this,sliceIds)]"}
set pie($this,sliceLabel,$sliceId) [pieLabeller::create $pie($this,labellerId) $sliceId -text $text -background $color]
$pie($this,canvas) addtag pie($this) withtag pieLabeller($pie($this,labellerId))
return $sliceId}
proc pie::sizeSlice {this sliceId unitShare {valueToDisplay {}}} {global slice
if {[set index [lsearch $pie($this,sliceIds) $sliceId]]<0} {error "could not find slice $sliceId in pie $this slices"}
set newExtent [expr [maximum [minimum $unitShare 1] 0]*360]
set growth [expr $newExtent-$slice($sliceId,extent)]
slice::update $sliceId [expr $slice($sliceId,start)-$growth] $newExtent
if {[string length $valueToDisplay]>0} {pieLabeller::update $pie($this,labellerId) $pie($this,sliceLabel,$sliceId) $valueToDisplay} else {pieLabeller::update $pie($this,labellerId) $pie($this,sliceLabel,$sliceId) $unitShare}
set value [expr -1*$growth]
foreach sliceId [lrange $pie($this,sliceIds) [incr index] end] {slice::rotate $sliceId $value
pieLabeller::rotate $pie($this,labellerId) $pie($this,sliceLabel,$sliceId)}}
proc pie::createTitle {this string font offset} {if {[string length $string]==0} {return}
set canvas $pie($this,canvas)
set box [$canvas bbox pie($this)]
set item [$canvas create text [expr ([lindex $box 2]-[lindex $box 0])/2] [expr [lindex $box 1]-$offset] -anchor s -tags pie($this) -text $string]
if {[string length $font]>0} {$canvas itemconfigure $item -font $font}}
proc piePeripheralLabeller::piePeripheralLabeller {this canvas args} pieLabeller {$canvas $args} {
    catch {set piePeripheralLabeller($this,smallFont) $pieLabeller($this,font)}
    array set option {-justify left}
    array set option $args
    catch {set piePeripheralLabeller($this,smallFont) $option(-smallfont)}
    catch {set piePeripheralLabeller($this,bulletWidth) $option(-bulletwidth)}
    set piePeripheralLabeller($this,justify) $option(-justify)
}
proc piePeripheralLabeller::~piePeripheralLabeller {this} {catch {delete $piePeripheralLabeller($this,array)}
$pieLabeller($this,canvas) delete pieLabeller($this)}
proc piePeripheralLabeller::create {this sliceId args} {set canvas $pieLabeller($this,canvas)
set valueId [$canvas create text 0 0 -tags pieLabeller($this)]
catch {$canvas itemconfigure $valueId -font $piePeripheralLabeller($this,smallFont)}
set box [$canvas bbox $valueId]
set smallTextHeight [expr [lindex $box 3]-[lindex $box 1]]
if {![info exists piePeripheralLabeller($this,array)]} {set options "-style split -justify $piePeripheralLabeller($this,justify)"
catch {lappend options -bulletwidth $piePeripheralLabeller($this,bulletWidth)}
catch {lappend options -font $pieLabeller($this,font)}
set box [$canvas bbox pie($pieLabeller($this,pieId))]
set piePeripheralLabeller($this,array) [eval new canvasLabelsArray $canvas [lindex $box 0] [expr [lindex $box 3]+(2*$pieLabeller($this,offset))+$smallTextHeight] [expr [lindex $box 2]-[lindex $box 0]] $options]}
set labelId [eval canvasLabelsArray::create $piePeripheralLabeller($this,array) $args]
$canvas addtag pieLabeller($this) withtag canvasLabelsArray($piePeripheralLabeller($this,array))
set piePeripheralLabeller($this,sliceId,$valueId) $sliceId
return $valueId}
proc piePeripheralLabeller::anglePosition {degrees} {return [expr (2*($degrees/90))+(($degrees%90)!=0)]}
set index 0
foreach anchor {w sw s se e ne n nw} {set piePeripheralLabeller(anchor,[piePeripheralLabeller::anglePosition [expr $index*45]]) $anchor
incr index}
unset index anchor
proc piePeripheralLabeller::update {this valueId value} {piePeripheralLabeller::rotate $this $valueId
$pieLabeller($this,canvas) itemconfigure $valueId -text $value}
proc piePeripheralLabeller::rotate {this valueId} {global PI
set canvas $pieLabeller($this,canvas)
set sliceId $piePeripheralLabeller($this,sliceId,$valueId)
slice::data $sliceId data
set midAngle [expr $data(start)+($data(extent)/2.0)]
set radians [expr $midAngle*$PI/180]
set x [expr ($data(xRadius)+$pieLabeller($this,offset))*cos($radians)]
set y [expr ($data(yRadius)+$pieLabeller($this,offset))*sin($radians)]
set angle [expr round($midAngle)%360]
if {$angle>180} {set y [expr $y-$data(height)]}
set coordinates [$pieLabeller($this,canvas) coords $valueId]
$pieLabeller($this,canvas) move $valueId [expr $data(xCenter)+$x-[lindex $coordinates 0]] [expr $data(yCenter)-$y-[lindex $coordinates 1]]
$canvas itemconfigure $valueId -anchor $piePeripheralLabeller(anchor,[piePeripheralLabeller::anglePosition $angle])}
pack [label .m -relief sunken -text "you may move a pie by holding down mouse button 1 over any part of it"] -fill x
set canvas [canvas .c -highlightthickness 0]
pack $canvas -fill both -expand 1
set pie1 [new pie $canvas 0 0 200 100 -thickness 20 -background gray -labeller [new pieBoxLabeller $canvas -justify center -offset 10] -title "this is pie #1" -titlefont fixed]
set slice11 [pie::newSlice $pie1]
set slice12 [pie::newSlice $pie1]
set slice13 [pie::newSlice $pie1]
set slice14 [pie::newSlice $pie1 {some text}]
set pie2 [new pie $canvas 0 0 200 100 -thickness 10 -background white -labeller [new piePeripheralLabeller $canvas -font variable -smallfont fixed -bulletwidth 1c] -title "this is pie #2" -titleoffset 20]
set slice21 [pie::newSlice $pie2]
set slice22 [pie::newSlice $pie2]
$canvas move pie($pie1) 10 40
$canvas move pie($pie2) 240 40
set extent [$canvas bbox all]
$canvas configure -width [expr [lindex $extent 2]-[lindex $extent 0]] -height [expr [lindex $extent 3]-[lindex $extent 1]]
for {set index 1} {$index<=2} {incr index} {$canvas bind pie([set pie$index]) <ButtonPress-1> "
        set xLast($index) %x
        set yLast($index) %y
    "
$canvas bind pie([set pie$index]) <Button1-Motion> "
        $canvas move pie([set pie$index]) \[expr %x-\$xLast($index)\] \[expr %y-\$yLast($index)\]
        set xLast($index) %x
        set yLast($index) %y
    "}
button .d -text {Delete Pies} -command "
    delete $pie1 $pie2
    .d configure -state disabled
    set delete 1
"
button .q -text Exit -command exit
pack .d .q -side left -fill x -expand 1
set delete 0
set u 1
proc refresh {} {global delete u pie1 pie2 slice11 slice12 slice13 slice14 slice21 slice22
if {$delete} {return}
set u [expr (3*$u)%31]
pie::sizeSlice $pie1 $slice11 [expr $u/100.0]
set u [expr (5*$u)%31]
pie::sizeSlice $pie1 $slice12 [expr $u/100.0]
set u [expr (7*$u)%31]
pie::sizeSlice $pie1 $slice13 [expr $u/100.0] "$u %"
pie::sizeSlice $pie2 $slice21 [expr $u/100.0] $u
set u [expr (11*$u)%31]
pie::sizeSlice $pie1 $slice14 [expr $u/100.0]
pie::sizeSlice $pie2 $slice22 [expr $u/100.0] $u
update
after 3000 refresh}
refresh
