proc dbdump {database {args ""}} {
	
	if [string match *-neowebscript* $args] {
		set args [lreplace $args [lsearch $args -neowebscript] [lsearch $args -neowebscript] {-neowebscript} {}]
	}
	if {$args != ""} {
		import_keyvalue_pairs data $args
	}

	if ![info exists data(pattern)] {set data(pattern) *}
	if ![info exists data(format)] {set data(format) parray}
	if ![info exists data(seperator)] {set data(seperator) ,}
	if ![info exists data(datafile)] {set data(datafile) remove}
	if {[info exists data(file)] && $data(datafile) == "remove"} {filerm data $data(file)}

	if [info exists data(file)] {set ofp [access_data_file $data(file)];seek $ofp 0 end}
    set keys ""
	foreach key [dbkeys $database $data(pattern)*] {
		dbfetch $database $key array

		if [info exists data(file)] {
			if [info exists data(neowebscript)] {	
				if ![info exists num] {
					set num 1
					puts $ofp "#THIS FILE IS FORMATED FOR NEOWEBSCRIPT DBIMPORT.  DO NOT REMOVE THIS COMMENT"
				}
				set line [list $key [array get array]]
				puts $ofp $line
				unset line
			} else {
				foreach elem [array names array] {
					append line "$array($elem)$data(seperator)"
				}
			puts $ofp "[crange $line 0 end-1]"	
			unset line
			if [array exists array] {unset array}
			}
		}

		if [info exists data(format)] {
			if {$data(format) == "parray"} {
				html "\[$key\]"
				parray array
				if [array exists array] {unset array}
			} elseif {$data(format) == "list"} {
				html "\[$key\]"
				foreach elem [array names array] {
					html "$elem=$array($elem), "
				}
				if [array exists array] {unset array}
			} elseif {$data(format) == "delineated"} {
				if [info exists data(neowebscript)] {
					if ![info exists num2] {
						set num2 1
						html "#THIS FILE IS FORMATED FOR NEOWEBSCRIPT DBIMPORT.  DO NOT REMOVE THIS COMMENT.\n"
					}
					set line [list $key [array get array]]
					html $line\n
					unset line
					if [array exists array] {unset array}
				} else {
					foreach elem [array names array] {
						append line "$array($elem)$data(seperator)"
					}
					html "[crange $line 0 end-1]\n"
					unset line
					if [array exists array] {unset array}
				}
			}
					
		}

    }

	if [info exists data(file)] {close $ofp}

    return
}

proc dbimport {file database args} {

	set num 0
	if [string match *-datafile* $args] {
		set args [lreplace $args [lsearch $args -datafile] [lsearch $args -datafile]]
		set ifp [access_data_file $file]
	} else {
		set ifp [open [pwd]/$file r]
	}

	import_keyvalue_pairs data $args
	set	n 0
	
	gets $ifp tmpline
	if {![string match "*NEO*SCRIPT DBIMPORT*" $tmpline] && [info exists data(fields)]} {
		seek $ifp 0
		set haveFields 1
	} else {
		set data(fields) 0
	}

	if ![info exists data(seperator)] {set data(seperator) ,}
	if ![info exists data(fields)] {error "-fields not set";return 0}
	if ![info exists data(key)] {set data(key) numbers}
	if ![info exists data(db)] {set data(db) remove}
	if {$data(db) == "remove"} {filerm db $database}
	
	while {[gets $ifp line] != -1} {
		if {$num != 0} {
			set tmpLine2 $line
			set line "$tmpLine\n$tmpLine2"
		}
		if {$line != ""} {
			if ![info exists haveFields] {
				set num [catch {array set storage [lindex $line 1]}]
				if {$num != 0} {
				set tmpLine $line
				} else {
					set key [lindex $line 0]
					dbstore $database $key storage
					if [array exists storage] {unset storage}
				}
				continue
			} else {
				set fields $data(fields)
			}
			incr n
			for {set i 0} {$i < [llength $fields]} {incr i} {
				if {[lindex $fields $i] != "key"} {
					set array([lindex $fields $i]) [lindex $line $i]
					if {[lindex $fields $i] == $data(key)} {
						set key [lindex $line $i]
					}
				} else {
					set id [lindex $line $i]
				}
			}

			if {[info exists data(key)] && $data(key) != "numbers"} {
				set id $key
			} elseif {[info exists id]} {
			} else {
				set id $n
			}

			dbstore $database $id array
		}	
	}
    return
}
