#### FROM HORACE ###
#
#  Updates
#
#  7-20-97  hav
#
#  1. Added logic to guard against one visitor record overflowing with
#     too many pages (keep the record size from getting too large)
#     When updating for an existing visitor record, the code checks
#     that no more than maxPagePerVis pages have been tracked for the visitor.
#     If that number is exceeded, then a new visitor record is started.
#
#     maxPagePerVis is defaulted to 75 but can be overridden by either
#     NeoWebServerConf(max_pages_per_visitor) or NeoWebUserConf(max_pages_per_visitor) 
#     (in that order of priority)
#
#  2. Changed report font colors from bright red and green (ff0000  00ff00) to
#     medium red and green (a50000  00a500) due to high contrast visibility problems.
#
#
#  8-21-96  hav
#
#  1. added cell_color arg to neotrack_report - optional; default="#ffffff"
#
#  2. added max number of visitor records allowed control parm.  This value
#     can be controled by the user AND by the server admin.
#     By default, a maximum of 5000 visitor records will be allowed in the
#     visitor database file.
#     The page owner may control this maximum by setting the 
#     NeoWebUserConf(max_visitors) value in a .htaccess file located in the
#     current dir or some higher dir.
#     The server admin may sontrol this value by setting the
#     NeoWebServerConf(max_visitors) value.
#     The priority order of settings from highest to lowest is
#      Server Admin   ...   User   ...   default
#
#  3. The report_visitor proc will accept a third (optional) argument
#     which is the bgcolor spec for the cells in the report.  This value
#    should be specified in a form that the browser will recognise
#    such as a rgb value in the form "#e0e0e0" (light gray)
#    the default value is white (i.e. "#ffffff")
#


#
# NeoWebScript [TM] development source code
#
# Tcl file that, when debugging is true, gets sourced every time a webpage 
# is pulled up that contains NeoWebScript server-side code. 
#
# If debugging is false, the file is loaded in only once by the
# "mother thread".
#
# $Id: neotrack.tcl,v 1.3 1998/01/02 22:12:29 tsunami Exp $
#

proc neotrack {{timeout 30} {thisdb NeoTrack}} {
    global webenv
    global NeoWebServerConf
    global NeoWebUserConf

    if {$timeout ==  "-"} {
        set timeout 30
    }
    set ctime [clock seconds]
    set to $webenv(DOCUMENT_URI)
    if {[info exists webenv(HTTP_REFERER)]} {
        set from $webenv(HTTP_REFERER)
    } else {
        set from "-"
    }
    if {[catch {set visitor_ip $webenv(REMOTE_ADDR)}]} {
        set visitor_ip 0.0.0.0
    }

	#
	# maxPagePerVis used to keep NeoTrack records from overflowing
	# due to too many pages visited by one visitor.  If overflow, then
	# simply start a new visitor record. 7-20-97 - hav
	#

    set maxPagePerVis 75
    if {[info exists NeoWebServerConf(max_pages_per_visitor)]} {
        set maxPagePerVis $NeoWebServerConf(max_pages_per_visitor)
    } elseif {[info exists NeoWebUserConf(max_pages_per_visitor)]} {
        set maxPagePerVis $NeoWebUserConf(max_pages_per_visitor)
    }
    if {[dbexists $thisdb]} {
        set keylist [lsort -ascii -decreasing [dbkeys $thisdb *_${visitor_ip}]] 
        if {[llength $keylist] >= 0} {
            set key [lindex $keylist 0]
            dbfetch $thisdb $key record
            if {[llength [array names record]] > 0} {
                set fieldlist [lsort -integer -decreasing [array names record]]
                set lastvisit [lindex $fieldlist 0]
                set last_timeout [lindex $record($lastvisit) 2]
                if {[expr $ctime - $lastvisit] <= [expr 60 * $last_timeout] && [llength $fieldlist] < $maxPagePerVis} {
                    #
                    # NOT a NEW visitor
                    #
                    set record($ctime) [list $from $to $timeout]
                    dbstore $thisdb $key record
                    return 0
               }
            }
        }
    }
    #
    # IS a NEW visitor
    #
    set key ${ctime}_${visitor_ip}
    set newrecord($ctime) [list $from $to $timeout]
    dbstore $thisdb $key newrecord
    #
    # now make the pageEntry record addition or update
    #
    set key [clock format $ctime -format "%Y%m%d"]$to
    set from [lindex [split $from ?] 0]
    if {[dbexists NeoTrackEntry]} {
        if {[dbfetch NeoTrackEntry $key parray]} {
            incr parray(daycount)
            if {[info exists parray($from)]} {
                incr parray($from)
            } else {
                set parray($from) 1
            }
        } else {
            set parray(daycount) 1
            set parray($from) 1
        }
    } else {
        set parray(daycount) 1
        set parray($from) 1
    }
    dbstore NeoTrackEntry $key parray
#
# now, if there are more than the max allowed visitor records
# then remove the last n oldest visitor records from the database
#
    set maxrec 5000
    if {[info exists NeoWebServerConf(max_visitors)]} {
        set maxrec $NeoWebServerConf(max_visitors)
    } elseif {[info exists NeoWebUserConf(max_visitors)]} {
        set maxrec $NeoWebUserConf(max_visitors)
    }
    set reclist [lsort -increasing -ascii [dbkeys $thisdb]]
    set num_to_delete [expr [llength $reclist] - $maxrec]
    for {set i 0} {$i < $num_to_delete} {incr i} {
        dbdelkey $thisdb [lindex $reclist $i]
    }
#
# finally return indicator that this is a new visitor
    return 1
}


proc neotrack_report {key {thisdb NeoTrack} {cell_color "#ffffff"}} {
    dbfetch $thisdb $key record
    set key_components [split $key _]
    set ctime [lindex $key_components 0]
    set visitor_ip [lindex $key_components 1]

    set page_list [lsort -integer -increasing [array names record]]
    set page_list_len [llength $page_list]
    set page_index 0

    html "<b>$visitor_ip</b> visited on <b>[clock format $ctime]</b><br>"
    html "<table border=\"1\" cellpadding=\"5\">"
    html "<tr><td valign=\"top\" bgcolor=\"$cell_color\"><b>From</b></td>"
    html "<td valign=\"top\" bgcolor=\"$cell_color\"><b>Page URI</b></td>"
    html "<td valign=\"top\" bgcolor=\"$cell_color\"><b>Enrty Time</b></td>"
    html "<td valign=\"top\" bgcolor=\"$cell_color\"><b>Visit Length</b><br>(<i>minutes</i>)</td>"
    html "<td valign=\"top\" bgcolor=\"$cell_color\"><b>Timeout</b><br>(<i>minutes</i>)</td></tr>"

    foreach vtime $page_list {
        set subrec(from) [lindex $record($vtime) 0]
        if {$subrec(from) == "-"} {
            set subrec(from) "!!_Manual_or_Initial_Load_!!"
        }
        set subrec(to) [lindex $record($vtime) 1]
        set subrec(timeout) [lindex $record($vtime) 2]
        if {$page_index > 0} {
            if {[string last $last(to) $subrec(from)] < 0} {
                html "<tr><td bgcolor=\"$cell_color\"><font color=\"#a50000\"><b>$subrec(from)</b></font></td>"
            } else {
                html "<tr><td bgcolor=\"$cell_color\">$subrec(from)</td>"
            }
            if {$last(to) == $subrec(to)} {
                html "<td bgcolor=\"$cell_color\"><font color=\"#00a500\"><b>$subrec(to)</b></font></td>"
            } else {
                html "<td bgcolor=\"$cell_color\">$subrec(to)</td>"
            }
        } else {
            if {$subrec(from) !=  "!!_Manual_or_Initial_Load_!!"} {
                html "<tr><td bgcolor=\"$cell_color\"><a href=\"$subrec(from)\">$subrec(from)</a></td>"
            } else {
                html "<tr><td bgcolor=\"$cell_color\">$subrec(from)</td>"
            }
            html "<td bgcolor=\"$cell_color\">$subrec(to)</td>"
        }
        html "<td bgcolor=\"$cell_color\">[clock format $vtime]</td>"
        if {[incr page_index] < $page_list_len} {
            set visit_time [expr [expr [lindex $page_list $page_index] - $vtime] / 60.0]
            html "<td bgcolor=\"$cell_color\">$visit_time</td>"
        } else {
            html "<td bgcolor=\"$cell_color\"></td>"
        }
        html "<td bgcolor=\"$cell_color\">$subrec(timeout)</td></tr>"
        set last(to) $subrec(to)
        set last(from) $subrec(from)
    }
    html "</table><p>"
}

