# $Id: wrap.tcl,v 1.3 1997/06/03 17:48:57 kunkee Exp $
# For wrapping text

proc wrap {string maxlen {html ""}} {
	set splitstring {}
	foreach line [split $string "\n"] {
		lappend splitstring [wrapline $line $maxlen $html]
	}
	if {$html == "-html"} {
		return [join $splitstring "<br>"]
	} else {
		return [join $splitstring "\n"]
	}
}

proc wrapline {line maxlen {html ""}} {
	set string [split $line " "]
	set newline [list [lindex $string 0]]
	foreach word [lrange $string 1 end] {
		if [clength $newline]+[clength $word]>$maxlen {
			lappend lines [join $newline " "]
			set newline {}
		}
		lappend newline $word
	}
	lappend lines [join $newline " "]
	if {$html == "-html"} {
		return [join $lines <br>]
	} else {
		return [join $lines "\n"]
	}
}
