#!/bin/sh

# create script to locate common programs
echo " "
echo "Locating common programs..." >&4
cat <<LOCATOR_SCRIPT >loc
$startsh
case \$# in
0) exit 1;;
esac
thing=\$1
shift
dflt=\$1
shift
for dir in \$*; do
    case "\$thing" in
    .)
    if test -d \$dir/\$thing; then
        echo \$dir
        exit 0
    fi
    ;;
    *)
    for thisthing in \$dir/\$thing; do
        : just loop through to pick last item
    done
    if test -f \$thisthing; then
        echo \$thisthing
        exit 0
    fi
    ;;
    esac
done
echo \$dflt
exit 1
LOCATOR_SCRIPT
chmod +x loc
# proper PATH separator
p_=:
# locate common Unix programs
loclist="
cat
chmod
chown
cp
date
du
echo
mkdir
mv
rm
sed
sendmail
"
pth=`echo $PATH | sed -e "s/$p_/ /g"`
pth="$pth /usr/lib /usr/sbin /lib"
for file in $loclist; do
    eval XXX=\$$file
    case "$XXX" in
    /*|?:[\\/]*)
        if test -f "$XXX"; then
            : ok
        else
            echo "WARNING: no $XXX -- ignoring your setting for $file." >&4
            XXX=`./loc $file $file $pth`
        fi
        ;;
    '') XXX=`./loc $file $file $pth`;;
    *) XXX=`./loc $XXX $XXX $pth`;;
    esac
    eval $file=$XXX
    eval _$file=$XXX
    case "$XXX" in
    /*)
        echo $file is in $XXX.
        ;;
    ?:[\\/]*)
        echo $file is in $XXX.
        ;;
    *)
        echo "I don't know where '$file' is, and my life depends on it." >&4
        echo "Go find a public domain implementation or fix your PATH setting!" >&4
        exit 1
        ;;
    esac
done
rm -rf ./loc

# begin NeoWebScript configurations
NEOROOT=`pwd`
APACHEROOT=$NEOROOT/apache_1.2.5
OLD=`date "+%Y.%m.%d:%H:%M:%S"`

if test -z "`echo -n`"
then
   _ECHO="echo -n"
   _ENDECHO=""
else
   _ECHO="echo"
   _ENDECHO="\\c"
fi

echon ( ) {
   $_ECHO "$*$_ENDECHO"
}

if test ! -d $NEOROOT/httpd -o ! -f $NEOROOT/LICENSE.NeoWebScript
then
   echo "This script must be run from the top-level directory after unpacking."
   exit 1
fi

cat << EOF

PLEASE NOTE: you should have Tcl built and installed before building
the NeoWebScript server.   Minimally, you need Tcl, TclX, and Neo, and
Gd.

EOF

SERVERROOT=$NEOROOT/httpd
cat << EOF
ServerRoot will be ${SERVERROOT}.
This is the directory which contains the configuration directory,
the log files, and other auxilliary information needed by NeoWebScript
and the Apache webserver.

EOF

sedflags="s%@SERVERROOT@%$SERVERROOT%"

DOCUMENTROOT=$SERVERROOT/htdocs
cat << EOF
DocumentRoot will be ${DOCUMENTROOT}.
This is the root directory containing all of your documents.  This can
be configured to a distinct directory if you wish.  You can safely point
to an existing DocumentRoot on your system.

EOF

ans=""
while test "$ans" != "y"
do
echon "Enter path to DocumentRoot (or hit return if $DOCUMENTROOT): "
read ans < /dev/tty
if test -n "$ans"
then
   DOCUMENTROOT="$ans"
fi
echo
echo "DocumentRoot will be $DOCUMENTROOT."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

if test ! -d $DOCUMENTROOT
then
   echo "$DOCUMENTROOT does not exist."
   echon "Should I create it? (y/n) "
   read ans < /dev/tty
   if test "$ans" = y
   then
      set -e
      mkdir -p $DOCUMENTROOT
      set +e
   fi
fi
if test $DOCUMENTROOT != $SERVERROOT/htdocs
then
      ln -s $SERVERROOT/httpd/htdocs/neowebscript $DOCUMENTROOT
      ln -s $SERVERROOT/httpd/htdocs/index.html $DOCUMENTROOT
fi

sedflags="$sedflags;s%@DOCUMENTROOT@%$DOCUMENTROOT%"

cat << EOF

The ServerAdmin directive should contain the email address of the
webserver administrator.
EOF

ans=""
while test "$ans" != "y"
do
echo
echo "Please enter the email address of the Web server administrator:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERADMIN="$ans"
fi
echo
echo "ServerAdmin will be $SERVERADMIN."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

sedflags="$sedflags;s%@SERVERADMIN@%$SERVERADMIN%"

cat << EOF

The Port directive determines which TCP port the webserver will listen
to.  The standard port is 80.  If you wish to make this an experimental
server on another port, choose a high number, such as 8080.
EOF

ans=""
while test "$ans" != "y"
do
SERVERPORT=80
echo
echo "Please enter the TCP port the webserver should use [$SERVERPORT]:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERPORT="$ans"
fi
echo
echo "Port will be $SERVERPORT."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done

sedflags="$sedflags;s%@SERVERPORT@%$SERVERPORT%"

cat << EOF

The ServerName directive sets the server name to issue in response headers.
By default, this is taken from the hostname, `hostname`.  You should enter
a different name if you want to prefix "www." for example, or if your
system does not present a fully qualified host name.  In any case, if you
enter a name, it should exist in the DNS database, unless perhaps this is
a corporate server that will not be seen by others on the Internet.
EOF

ans=""
while test "$ans" != "y"
do
SERVERNAME="default"
echo
echo "Please enter the server name [$SERVERNAME]:"
read ans < /dev/tty
if test -n "$ans"
then
   SERVERNAME="$ans"
fi
echo
echo "ServerName will be $SERVERNAME."
echon "Is this correct? (y/n) "
read ans < /dev/tty
done
if test -z "$SERVERNAME" -o "$SERVERNAME" = default
then
   SERVERNAME=""
else
   SERVERNAME="ServerName $SERVERNAME"
fi

sedflags="$sedflags;s%@SERVERNAME@%$SERVERNAME%"


{
echo "Entering $NEOROOT/httpd"
cd $NEOROOT/httpd

# building management script
if test -f neowebscript
then
    echo "Backing up previous neowebscript management script"
    mv neowebscript neowebscript-$OLD
fi
echo "Creating management script 'neowebscript' for system restart"
sed -e "$sedflags" ../install/neowebscript.in > neowebscript
chmod +x neowebscript

# building cgi-bin directory
if test -f cgi-bin
then
    echo "Backing up previous cgi-bin directory"
    mv cgi-bin cgi-bin-$OLD
fi
echo "Creating cgi-bin directory"
mkdir cgi-bin
echo "Setting ownership and directory permissions"
chown nobody:nobody cgi-bin
chmod 755 cgi-bin

# building logs directory
if test -d logs
then
    echo "Backing up existing logs directory"
    mv logs logs-$OLD
fi
echo "Creating logs directory"
mkdir logs
echo "Setting ownership and directory permissions"
chown nobody:nobody logs
chmod 755 logs

# building neoscript-data directories
if test -d neoscript-data
then
    echo "Backing up existing neoscript-data directory"
    mv neoscript-data neoscript-data-$OLD
fi
echo "Creating neoscript-data/{system,users}"
mkdir neoscript-data
mkdir neoscript-data/system neoscript-data/users
echo "Setting ownership and directory permissions"
chown nobody:nobody neoscript-data neoscript-data/system neoscript-data/users
chmod 755 neoscript-data neoscript-data/system neoscript-data/users

# building bin directories
if test -d bin
then
    echo "Backing up existing neoscript-data directory"
    mv bin bin-$OLD
fi
echo "Creating httpd/bin and src/Makefile for webunpack and getpass"
mkdir bin
if test -s /usr/include/shadow.h
then
  sedflags="$sedflags;s%@SHADOW_FLAGS@%-DHAVE_SHADOW%"
else
  sedflags="$sedflags;s%@SHADOW_FLAGS@%%"
fi
sed -e "$sedflags" $NEOROOT/src/Makefile.in > $NEOROOT/src/Makefile

# adding full paths to call external programs
sedflags="$sedflags;s%@SENDMAIL@%$sendmail%;s%@DU@%$du%"

# building apache configuration files
cd conf
echo "Entering httpd/conf"
for f in access httpd srm
do
  if test -f $f.conf
  then
    echo "Backing up existing $f.conf"
    mv $f.conf $f.conf-$OLD
  fi
  echo "Initializing $f.conf from $f.conf-dist"
  sed -e "$sedflags" $f.conf-dist > $f.conf
done

echo "Leaving httpd/conf"
echo "Leaving httpd"
}

{
# Copy some useful files and directories from Apache
#
echo "Copying $APACHEROOT/icons"
cp -R $APACHEROOT/icons $SERVERROOT
echo "Creating symlinks to the Apache manual"
ln -s $APACHEROOT/htdocs/manual $DOCUMENTROOT/apache_manual
}

#echo Installing startup script in /etc/init.d/neowebscript
#ln -s ../init.d/neowebscript /etc/rc3.d/S99neowebscript
#ln -s $NEOROOT/httpd/neowebscript /etc/init.d
#
#/etc/init.d/neowebscript start
