#!/bin/sh

if [ $# = "0" ]
then
  echo "Usage: $0 <PREFIX> ?DB_PREFIX?"
  exit 1
fi

PREFIX=$1
DBPREFIX=$1
NEO_INCLUDES=-I$PREFIX/include
if [ $# = "2" -a "$1" != "$2" ]
then
  DBPREFIX=$2
  NEO_INCLUDES="$NEO_INCLUDES -I$DBPREFIX/include"
fi
file1='static1.patch'
file2='static2.patch'
rm -f $file1 $file2

cat >> $file1 << EOF
*** apache_1.3.6/src/Makefile
***************
*** 49,56 ****
  ##
  
  
  CFLAGS=\$(OPTIM) \$(CFLAGS1) \$(EXTRA_CFLAGS)
! LIBS=\$(EXTRA_LIBS) \$(LIBS1)
  INCLUDES=\$(INCLUDES1) \$(INCLUDES0) \$(EXTRA_INCLUDES)
  LDFLAGS=\$(LDFLAGS1) \$(EXTRA_LDFLAGS)
  
--- 49,57 ----
  ##
  
  
+ NEO_LIBS=-L$PREFIX/lib -ltcl8.1 -ltclx8.1 -lneo8.1.1 -ldb -lgd1.2
  CFLAGS=\$(OPTIM) \$(CFLAGS1) \$(EXTRA_CFLAGS)
! LIBS=\$(EXTRA_LIBS) \$(LIBS1) \$(NEO_LIBS)
  INCLUDES=\$(INCLUDES1) \$(INCLUDES0) \$(EXTRA_INCLUDES)
  LDFLAGS=\$(LDFLAGS1) \$(EXTRA_LDFLAGS)
EOF

 
cat >> $file2 << EOF
*** apache_1.3.6/src/modules/extra/Makefile
***************
*** 43,50 ****
  ##  Default Makefile options from Configure script
  ##  (Begin of automatically generated section)
  ##
! CFLAGS=\$(OPTIM) \$(CFLAGS1) \$(EXTRA_CFLAGS)
  LIBS=\$(EXTRA_LIBS) \$(LIBS1)
! INCLUDES=\$(INCLUDES1) \$(INCLUDES0) \$(EXTRA_INCLUDES)
  LDFLAGS=\$(LDFLAGS1) \$(EXTRA_LDFLAGS)
  INCDIR=\$(SRCDIR)/include
--- 43,52 ----
  ##  Default Makefile options from Configure script
  ##  (Begin of automatically generated section)
  ##
+ NEO_CFLAGS=-DGDTCL
+ NEO_INCLUDES=$NEO_INCLUDES
! CFLAGS=\$(OPTIM) \$(CFLAGS1) \$(EXTRA_CFLAGS) \$(NEO_CFLAGS)
  LIBS=\$(EXTRA_LIBS) \$(LIBS1)
! INCLUDES=\$(INCLUDES1) \$(INCLUDES0) \$(EXTRA_INCLUDES) \$(NEO_INCLUDES)
  LDFLAGS=\$(LDFLAGS1) \$(EXTRA_LDFLAGS)
  INCDIR=\$(SRCDIR)/include
EOF
