PREFIX=$1
CONFDIR="$PREFIX/conf"
BINDIR="$PREFIX/bin"

if [ ! -f $CONFDIR/httpd.conf.orig ]
then
  cp $CONFDIR/httpd.conf $CONFDIR/httpd.conf.orig
  cat >> $CONFDIR/httpd.conf << EOF
####
#### NeoWebScript-specific Apache configuration lines
#### (uncomment to activate)
####
#   Enable the NeoWebScript handler
#AddType text/html .nhtml .nws
#AddHandler neo-server-parsed .nhtml .nws

## Enable these two lines if you want GD Image Generation support turned on.
#AddType image/gif .gd
#AddHandler neo-generate-image .gd

#   Add this line to the <Directory></Directory> blocks that
#    you want to have NeoWebScript.
#Options Includes

#   Add this line so that directories can have NeoWebScript as
#    their indicies.
#DirectoryIndex index.nhtml index.html default.nhtml default.html

#   Uncomment this line to enable nws-common in VirtualHosts
#Alias /nws-common/ $PREFIX/htdocs/nws-common
#### End of NeoWebScript configuration ####
###########################################
EOF

fi

if [ ! -f $BINDIR/apachectl.orig ]
then
  cp $BINDIR/apachectl $BINDIR/apachectl.orig
  echo "#!/bin/sh" > $BINDIR/apachectl
  echo "LD_LIBRARY_PATH=$PREFIX/lib:\$LD_LIBRARY_PATH" >> $BINDIR/apachectl
  echo "export LD_LIBRARY_PATH" >> $BINDIR/apachectl
  cat $BINDIR/apachectl.orig >> $BINDIR/apachectl
fi
