# Version tag: change presentation based on date and release
#
# Example .htaccess:
# NeoWebUserConf vtag_release 1.0
# NeoWebUserConf vtag_newdays 14
# NeoWebUserConf vtag_newhtml_begin "<font color=#00ff00>"
# NeoWebUserConf vtag_newhtml_end "</font>"
# NeoWebUserConf vtag_nextrelhtml_begin "<font color=#0000FF>"
# NeoWebUserConf vtag_nextrelhtml_end "</font>"
# NeoWebUserConf vtag_2.0html_begin "<font color=#FF0000>"
# NeoWebUserConf vtag_2.0html_end "</font>"

proc vtag {date args} {
    import_keyvalue_pairs opt $args
    upvar NeoWebUserConf conf

    if ![info exists opt(newdays)] {set opt(newdays) $conf(vtag_newdays)}
    set startTime [clock scan $date]
    if [info exists opt(use_version)] {
		return $conf(vtag_$opt(use_version)html_$opt(place))
	}
    if { [clock seconds] > $startTime + 24*60*60 * $opt(newdays)} {
	if {$opt(release) > $conf(vtag_release)} {
		if [info exists opt(text)] {
			return $conf(vtag_nextrelhtml_begin)$opt(text)$conf(vtag_nextrelhtml_end)
		}
		return $conf(vtag_nextrelhtml_$opt(place))
	} else {
	    return
	}
    } else {
	if [info exists opt(text)] {
		return $conf(vtag_newhtml_begin)$opt(text)$conf(vtag_newhtml_end)
	}
	return $conf(vtag_newhtml_$opt(place))
    }
}
