# neoConfig.sh --
# 
# This shell script (for sh) is generated automatically by Neo's
# configure script.  It will create shell variables for most of
# the configuration options discovered by the configure script.
# This script is intended to be included by the configure scripts
# for Neo extensions so that they don't have to figure this all
# out for themselves.  This file does not duplicate information
# already provided by tclConfig.sh, so you may need to use that
# file in addition to this one.
#
# The information in this file is specific to a single platform.
#
# SCCS: @(#) neoConfig.sh.in 1.5 96/04/15 09:49:11

# Neo's version number.
NEO_VERSION='8.1.1'
NEO_MAJOR_VERSION='8'
NEO_MINOR_VERSION='1'

# -D flags for use with the C compiler.
NEO_DEFS='-DHAVE_CONFIG_H'

# The name of the Neo library (may be either a .a file or a shared library):
NEO_LIB_FILE=libneo8.1.1.so

# Additional libraries to use when linking Neo.
NEO_LIBS='-ldl  -lcrypt '

# Top-level directory in which Tcl's platform-independent files are
# installed.
NEO_PREFIX='/usr/local/apache'

# Top-level directory in which Tcl's platform-specific files (e.g.
# executables) are installed.
NEO_EXEC_PREFIX='/usr/local/apache'

# String to pass to linker to pick up the Neo library from its
# build directory.
NEO_BUILD_LIB_SPEC='-L/usr/local/apache/src/neotcl8.1.1-lite/neo8.1.1/generic -lneo8.1.1'

# String to pass to linker to pick up the Neo library from its
# installed directory.
NEO_LIB_SPEC='-L/usr/local/apache/lib -lneo8.1.1'

# Flags to pass to ld, such as "-R /usr/local/tcl/lib", that tell the
# run-time dynamic linker where to look for shared libraries such as
# libtcl.so.  Used when linking applications.  Only works if there
# is a variable "LIB_INSTALL_DIR" defined in the Makefile.
NEO_LD_SEARCH_FLAGS='-Wl,-R,${LIB_RUNTIME_DIR}'

NEO_CFLAGS=' -DNEO_DB -DNEOSOFT_TCL_ENCRYPTION'
NEO_LDFLAGS=''

# Flags that were used to link to the Sleepycat DB library
NEO_DB_BUILD_LIB_SPEC='-L../tools/db-2.7.5/build_unix -ldb'
NEO_DB_LIB_SPEC='-L/usr/local/apache/lib -ldb'
