load_response

set image [gd create 150 150]

random seed
set pi 3.1415
set black [gd color new $image [random 256] [random 256] [random 256]]
set white [gd color new $image 255 255 255]
set radius $response(radius)
set angle1 $response(st)
set angle2 $response(end)

# convert the degrees into radians
set ang1 [expr $pi*$angle1/180]
set ang2 [expr $pi*$angle2/180]

gd fillrectangle $image $white 0 0 150 150

# While this may be complicated, it is as general as possible
gd line $image $black 75 75 [expr round(75 + $radius*cos($ang1))] [expr round(75 - $radius*sin($ang1))]
gd line $image $black 75 75 [expr round(75 + $radius*cos($ang2))] [expr round(75 - $radius*sin($ang2))]
gd arc $image $black 75 75 [expr 2*$radius] [expr 2*$radius] [expr round(360 - $angle2)] [expr round(360 - $angle1)]

# To fill the arc, we find the halfangle, and go halfway up the radius
set halfang [expr $pi*($angle1 + $angle2)/360]
gd fill $image $black [expr round(75 + ($radius/2)*cos($halfang))] [expr round(75 - ($radius/2)*sin($halfang))]

gd writeGIF $image $imageFile
return
