#@package: oracle-basic quote_oracle clock_to_oracle_time gen_oracle_insert_from_array

#
# Copyright (C) 1996-1997 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# oracle interface stuff
#
# $Id: basic.tcl,v 1.1.1.1 1999/03/31 20:34:40 damon Exp $
#

#
# make string mostly legally quoted for oracle 
#
proc quote_oracle {string} {
    set string [join [split $string "\n"] "\\n"]
    regsub -all "(')" $string "\''" string
    regsub -all {(\\)} $string "\\\\" string
    return '$string'
}

#
# generate an oracle insert command based on contents of an array
#
proc gen_oracle_insert_from_array {tableName arrayName} {
    upvar $arrayName array

    set nameList [array names array]

    set result "insert into $tableName ([join $nameList ","]) values ("

    foreach name $nameList {
	append result "[quote_oracle $array($name)],"
    }
    return "[crange $result 0 end-1]);"
}

#
# convert a clock value (integer seconds since 1970) to an oracle date.
#
#        dd-mmm-yy
#
proc clock_to_oracle_time {clock} {
    return [fmtclock $clock "%d-%b-%y"]
}

