# $Id: picgrid.tcl,v 1.4 94/02/06 14:32:40 mangin Exp $
set GridSpacing 5
set GridUnit {mm}
set UnitSuffix(pixel) {}
set UnitSuffix(mm) {m}
set UnitSuffix(cm) {c}
set UnitSuffix(inch) {i}
set UnitSuffix(pica) {p}

#  Third arg to pass to canvas<x|y>  #
set GridSpec ""

set gridEntryVar $GridSpacing

################################################################
####	Returns canvas coordinates according to             ####
####	     gridding mode and grid spacing                 ####
################################################################

proc grid {args} {
  global GridSpec

  set res [eval "[cv] canvasx [lindex $args 0] $GridSpec"]
  if {![catch {lindex $args 1} y]} {
    lappend res [eval "[cv] canvasy $y $GridSpec"]
  }

  return $res
}

################################################################
####		  Toggles grid showing                      ####
################################################################

set ShowingGrid 0

proc toggleShowGrid {} {
  global ShowingGrid

  if {$ShowingGrid} {
    set ShowingGrid 0
    .optionFr.gridFr.showBt configure \
      -text { Show Grid }
    hideGrid
  } else {
    .optionFr.gridFr.showBt configure \
      -text { Hide Grid }
    showGrid
    set ShowingGrid 1 }
}

################################################################
####      Hide grid, i.e. destroys the ruler canvases       ####
################################################################

proc hideGrid {} {
  destroy .frame2.frame21
  destroy .frame2.frame22.cv
  update
}

################################################################
####       Show grid, i.e. create the rulers canvases       ####
################################################################

proc showGrid {} {

  frame .frame2.frame21 -borderwidth 0
  
  frame .frame2.frame21.dummy \
    -borderwidth 0 \
    -width 12

  canvas .frame2.frame21.cv \
    -height 12
  
  canvas .frame2.frame22.cv \
    -width 12
  
  pack append .frame2.frame21 \
    .frame2.frame21.dummy {left fill} \
    .frame2.frame21.cv    {left expand fill}

  pack .frame2.frame22.cv \
    -before .frame2.frame22.canvas \
    -side left -fill y

  pack .frame2.frame21 \
    -before .frame2.frame22 \
    -side top -fill x

  update
  drawTicks
}

################################################################
####	 Draws the ticks in the ruler canvases              ####
################################################################

proc drawTicks {} {

  .frame2.frame21.cv delete all
  .frame2.frame22.cv delete all

  if {[catch {readGridSpacing} gspec]} {
    warn $gspec
  } else {
    set x 0
    set index 0
    .frame2.frame21.cv create line \
      $x 0 $x 9
    while {$x < 1152} {
      incr index
      if {[expr "($index % 5) == 0"]} {
	set len 9
      } else {
	set len 6
      }
      set item [.frame2.frame21.cv create line \
		$x 0 $x $len]
      .frame2.frame21.cv move $item \
	$gspec 0
      set x [lindex [.frame2.frame21.cv coords $item] 0]
    }
  
    set y 0
    set index 0
    .frame2.frame22.cv create line \
      0 $y 9 $y
    while {$y < 1000} {
      incr index
      if {[expr "($index % 5) == 0"]} {
	set len 9
      } else {
	set len 6
      }
      set item [.frame2.frame22.cv create line \
		0 $y $len $y]
      .frame2.frame22.cv move $item \
	0 $gspec
      set y [lindex [.frame2.frame22.cv coords $item] 1]
    }
  }

  .frame2.frame21.cv lower \
    [.frame2.frame21.cv create polygon \
     -4 0 4 0 0 11 -fill red -tags {pointerPos}]
  
  .frame2.frame22.cv lower \
    [.frame2.frame22.cv create polygon \
     0 -4 0 4 11 0 -fill red -tags {pointerPos}]
}
    
################################################################
####		    Canvas bindings:                        ####
####	    - move cursors on pointer moves                 ####
####		- redraw ticks on resize                    ####
################################################################

proc GridSetBindings {} {
  bind [cv] <Motion>                 {+ GridHandle motion %x %y}
  bind [cv] <Button1-Motion>         {+ GridHandle motion %x %y}
  bind [cv] <Button2-Motion>         {+ GridHandle motion %x %y}
  bind [cv] <Button3-Motion>         {+ GridHandle motion %x %y}
  bind [cv] <ButtonPress-1>          {+ GridHandle press %x %y}
  bind [cv] <ButtonPress-2>          {+ GridHandle press %x %y}
  bind [cv] <ButtonPress-3>          {+ GridHandle press %x %y}
  bind [cv] <ButtonRelease-1>        {+ GridHandle release %x %y}
  bind [cv] <ButtonRelease-2>        {+ GridHandle release %x %y}
  bind [cv] <ButtonRelease-3>        {+ GridHandle release %x %y}
}

proc GridHandle {type x y} {
  global ShowingGrid

  if { $ShowingGrid } {
    switch $type {
      motion {
	##  mv the position arrows  ##
	lassign [grid $x $y] x y

	set oldx [lindex [.frame2.frame21.cv coords pointerPos] 0]
	.frame2.frame21.cv move pointerPos \
	  [expr $x - 4 - ($oldx)] 0

	set oldy [lindex [.frame2.frame22.cv coords pointerPos] 1]
	.frame2.frame22.cv move pointerPos \
	  0 [expr $y - 4 - ($oldy)]
      }
      press {
	##  create the start-drag arrows  ##
	lassign [grid $x $y] x y

	.frame2.frame21.cv lower \
	  [.frame2.frame21.cv create polygon \
	   [expr $x - 4] 0 [expr $x + 4] 0 $x 11 \
	     -fill {blue} -tags {forDrag}]

	.frame2.frame22.cv lower \
	  [.frame2.frame22.cv create polygon \
	   0 [expr $y - 4] 0 [expr $y + 4] 11 $y \
	     -fill {blue} -tags {forDrag}]
      }
      release {
	##  delete the start-drag arrows  ##
	.frame2.frame21.cv delete forDrag
	.frame2.frame22.cv delete forDrag
      }
    }
  }
}
  
################################################################
####			 Dialog                             ####
################################################################

proc gridShowDialog {} {
}

proc gridSpacingUpdate {} {
  global ShowingGrid GriddingMode
  global GridSpacing GridSpec UnitSuffix GridUnit
  
  if {[catch {readGridSpacing} GridSpec]} {
    warn $GridSpec
    set GridSpec ""
  } else {
    focus .
    if {$GriddingMode} {
      set GridSpec "$GridSpacing$UnitSuffix($GridUnit)"
    } else {
      set GridSpec ""
    }
    if {$ShowingGrid} {
      drawTicks
    }
  }
}

proc readGridSpacing {} {
  global gridEntryVar
  global GridSpacing UnitSuffix GridUnit
  
  scan $gridEntryVar {%f} value
  if { $value == [string trim $gridEntryVar] } {
    set GridSpacing $value
    return "$GridSpacing$UnitSuffix($GridUnit)"
  } else {
    error "Floating point value required"
  }
}

##
##  gridObject:
##  
##    Tries to arrange for object vertices to
##      fall on grid points -> object type dependent
##

proc gridObject {tagOrId} {

  foreach id [[cv] find withtag $tagOrId] {
    switch [[cv] type $id] {

      orectangle -
      frectangle -
      image {
	# first grid the dims #
	lassign [grid \
		 [lindex [[cv] itemconf $id -width] 4] \
		   [lindex [[cv] itemconf $id -height] 4]] w h
	[cv] itemconfigure $id \
	  -width $w -height $h
	set w [expr 0.5 * $w]
	set h [expr 0.5 * $h]
	#  then grid ul-vertex  #
	lassign [[cv] coords $id -vertices] x1 y1
	lassign [grid $x1 $y1] X1 Y1
	[cv] move $id \
	  [expr $X1 - $x1] [expr $Y1 - $y1]
      }

      line -
      dline -
      rectangle -
      drectangle -
      polygon -
      oval -
      doval -
      text {
	set coords [[cv] coords $id]
	set newcoords {}
	loop i 0 [llength $coords] 2 {
	  set newcoords \
	    "$newcoords [eval "grid [lrange $coords $i [expr $i + 1]]"]"
	}
	eval "[cv] coords $id $newcoords"
      }
    }
  }
}


      

				     
		 

