

set errTrue 1
set errFalse 0

########################################################################
## Test the behaviour of wrong typed assignments

set allTypes {Short UShort Int Unsigned Float Double}
set l [llength $allTypes]
for {set i 0} {$i<$l} {incr i} {
  set t1 [lindex $allTypes $i]
  for {set j [expr $i+1]} {$j<$l} {incr j} {
    set t2 [lindex $allTypes $j]
    performTest "assign: $t1 <- $t2" $errTrue \
	{b is not of the same type as a} "
      $t1 a
      $t2 b
      b insert end 1
      a copy end b
    "
  }
}
########################################################################
## Some simple correct assignments
foreach x $allTypes {
  performTest "assign: $x <- $x" $errFalse b "
    $x a b
    a insert end 1
    b copy end a
  "
}     
########################################################################
## 
