set errTrue 1
set errFalse 0

########################################################################
## Test of conversions string-->binary and their error messages

set allTypes {Short UShort Int Unsigned Float Double}
set names {short {unsigned short} int unsigned float double}
set goodValues {-131 121 -100001 999000 3.14159 -2.01}
set overflow {-100000 100000 9999999999 9999999999 1e88 1e999}
set l [llength $allTypes]

## Several right and wrong assignments
for {set i 0} {$i<$l} {incr i} {
  set type [lindex $allTypes $i]
  set name [lindex $names $i]
  set val [lindex $goodValues $i]
  set ovf [lindex $overflow $i]
  
  performTest "convert1 ($type)" $errTrue \
      "illegal $name value: `bla'" \
      "$type a ; a insert end bla"

  performTest "convert2 ($type)" $errTrue \
      "illegal $name value: `$val x'" \
      "$type a ; a insert end {{$val x}}"

  performTest "convert3 ($type)" $errFalse \
      "$val" \
      "$type a ; a insert end $val ; a get"

  performTest "convert4 ($type)" $errTrue \
      "$name value out of range: `$ovf'" \
      "$type a ; a insert end $ovf"  
}  

  