set errTrue 1
set errFalse 0

########################################################################
## Test the behaviour of copy command

performTest copy.wrong-num-args $errTrue \
    {wrong # args: should be `a copy dstIndex srcBita ?from? ?to?'} \
	 {Float a; a copy}

performTest copy.wrong-dst-index $errTrue \
	 {index out of range: `2'} \
	 {Float a b; b insert end "1 2 3"; a copy 2 b}


performTest copy.src-no-bita $errTrue \
	 {bla is no binary typed array} \
	 {Float a ; a copy end bla}

performTest copy.src-empty $errTrue \
	 {b is empty} \
	 {Float a b; a copy end b}

performTest copy.5-args $errTrue \
	 {index out of range: `-1'} \
	 {Float a b; b insert end 1; a copy end b -1}

performTest copy.6-args $errTrue \
	 {index out of range: `-1'} \
	 {Float a b; b insert end 1; a copy end b 0 -1}
	 
performTest copy.6-args-exch $errTrue \
	 {`from'-index may not be greater than `to'-index} \
	 {Float a b; b insert end "1 2 3"; a copy end b 2 0}

performTest copy.src-is-dst $errFalse \
	 {1 2 1 2} \
	 {Float a b; a insert end "1 2"; a copy end a; a get}