set errTrue 1
set errFalse 0

########################################################################
## Some general tests

performTest bita.UShort-wrong-num-args $errTrue \
    "wrong \# args: should be `UShort varName ?varName? ...'"\
    {UShort}

performTest bita.Short-wrong-num-args $errTrue \
    "wrong \# args: should be `Short varName ?varName? ...'"\
    {Short}

performTest bita.Unsigned-wrong-num-args $errTrue \
    "wrong \# args: should be `Unsigned varName ?varName? ...'"\
    {Unsigned}

performTest bita.Int-wrong-num-args $errTrue \
    "wrong \# args: should be `Int varName ?varName? ...'"\
    {Int}

performTest bita.Float-wrong-num-args $errTrue \
    "wrong \# args: should be `Float varName ?varName? ...'"\
    {Float}

performTest bita.Double-wrong-num-args $errTrue \
    "wrong \# args: should be `Double varName ?varName? ...'"\
    {Double}

foreach x {UShort Short Unsigned Int Float Double} {
  performTest bita.$x-no-arg $errTrue \
    "wrong \# args: should be `a option ?arg ...?'" \
    "$x a; a"
}

if { [haveFeature SIGPROC] } {
  set err "bad option `blarilu': must be copy, get, minmax, insert,"
  append err " length,"
} else {
  set err "bad option `blarilu': must be copy, get, insert, length,"
}

append err " pop, push, read, remove, set, swap, trunc, type, write"
foreach x {UShort Short Unsigned Int Float Double} {
  performTest bita.$x-wrong-arg $errTrue \
      $err \
      "$x a; a blarilu"
}

########################################################################
## squeeze out some bits of the source-code to have tcov show that
## every basic block was executed.

performTest indexCheck1 $errTrue \
    {illegal index value: `bla'} \
    {
      Short a
      a insert 0 "1 2 3"
      a insert bla 1
    }
