set errTrue 1
set errFalse 0

########################################################################
## Test the behaviour of minmax command

if {[haveFeature SIGPROC]} {

  performTest minmax.wrong-num-args $errTrue \
      "wrong \# args: should be `a minmax ?from? ?to?'" \
      {Float a ; a minmax bla bli blu}
  
  performTest minmax.empty-bita $errTrue \
      {a is empty} \
      {Float a ; a minmax}
  
  performTest minmax.3-args-wrong $errTrue \
      {index out of range: `-1'} \
      {Float a ; a insert end 1; a minmax -1}
  
  performTest minmax.4-args-wrong $errTrue \
      {index out of range: `-1'} \
      {Float a ; a insert end 1; a minmax 0 -1}
  
  performTest minmax.4-args-index-exch $errTrue \
      {`from'-index may not be greater than `to'-index} \
      {Float a ; a insert end "1 2 3"; a minmax 2 0}
  
  foreach x {UShort Short Unsigned Int Float Double} {
    $x a
    performTest minmax.1-$x $errFalse \
	{1} \
	{
	  a insert end {33 100 101 102 103 104 105 121};
	  set b [a minmax]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
    performTest minmax.2-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {121 100 101 102 103 104 105 33};
	  set b [a minmax]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
    performTest minmax.3-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {88 121 100 101 102 103 104 105 33 88};
	  set b [a minmax]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
    performTest minmax.4-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {88 33 100 101 102 103 104 105 121 88};
	  set b [a minmax]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
    performTest minmax.5-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {100}
	  set b [a minmax]
	  expr [lindex $b 0]==100 && [lindex $b 1]==100
	}
    
    performTest minmax.6-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {88 33 100 101 102 103 104 105 121 88};
	  set b [a minmax 1]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
    performTest minmax.7-$x $errFalse \
	{1} \
	{
	  a trunc 0
	  a insert end {88 33 100 101 102 103 104 105 121 88};
	  set b [a minmax 0 8]
	  expr [lindex $b 0]==33 && [lindex $b 1]==121
	}
    
  }
}
