set errTrue 1
set errFalse 0

########################################################################
## Tests of push command

performTest push.wrong-num-args $errTrue \
    "wrong \# args: should be `a push value'" \
    {Float a; a push 1 b}

performTest push.many-new $errFalse \
    {999} \
    {
      Int a
      for {set i 0} {$i<1000} {incr i} {
	a push $i
      }
      a get 999
    }

performTest push.UShort-wrong-value $errTrue \
    {illegal unsigned short value: `b'}\
    {UShort a; a push b}

performTest push.Short-wrong-value $errTrue \
    {illegal short value: `b'}\
    {Short a; a push b}

performTest push.Unsigned-wrong-value $errTrue \
    {illegal unsigned value: `b'}\
    {Unsigned a; a push b}

performTest push.Int-wrong-value $errTrue \
    {illegal int value: `b'}\
    {Int a; a push b}

performTest push.Float-wrong-value $errTrue \
    {illegal float value: `b'}\
    {Float a; a push b}

performTest push.Double-wrong-value $errTrue \
    {illegal double value: `b'}\
    {Double a; a push b}

