set errTrue 1
set errFalse 0

## make sure, we've got a file

global file
set file /tmp/bitaTest.[pid]

set f [open $file w]
close $f


########################################################################
## Tests of read and write commands

########################################################################
## basic read tests
performTest read.wrong-num-args $errTrue \
    "wrong \# args: should be `a read dstIndex file count'" \
    {Float a; a read}

performTest read.wrong-dstIndex $errTrue \
    {index out of range: `-1'} \
    {Float a; a read -1 bla 1}

performTest read.wrong-file $errTrue \
    {can not find channel named "bla"} \
    {Float a; a read end bla 1}


set f [open $file r]

performTest read.wrong-count1 $errTrue \
    {wrong count `bla'} \
    "Float a; a read end $f bla"

performTest read.wrong-count2 $errTrue \
    {wrong count `1 b'} \
    "Float a; a read end $f {1 b}"

close $f


########################################################################
## basic write tests
performTest write.wrong-num-args $errTrue \
    "wrong \# args: should be `a write file ?from? ?to?'" \
    {Float a; a write}

performTest write.empty $errTrue \
    {a is empty} \
    {Float a; a write a}

performTest write.wrong-file $errTrue \
    {can not find channel named "f"} \
    {Float a; a insert end 1; a write f}

set f [open $file w]
performTest write.wrong-startIndex $errTrue \
    {index out of range: `44'} \
    "Float a; a insert end 1; a write $f 44"

performTest write.wrong-endIndex $errTrue \
    {index out of range: `44'} \
    "Float a; a insert end 1; a write $f 0 44"

performTest write.index-exch $errTrue \
    {`from'-index may not be greater than `to'-index}\
    "Float a; a insert end {1 2 3 4}; a write $f 3 0"
close $f

performTest write.ok1 $errFalse \
    {1} \
    {
      global file
      Float a
      a insert end 1
      set f [open $file w]
      set x [a write $f]
      close $f
      set x
    }
########################################################################
## read and write together
performTest write.ok2 $errFalse \
    {4000} \
    {
      global file
      Int a
      for {set i 0} {$i<1000} {incr i} {
	a insert end $i
      }
      set f [open $file w]
      a write $f
      close $f
      file stat $file s
      set s(size)
    }

performTest read.ok1 $errFalse \
    {500 501 502} \
    {
      global file
      Int a
      set f [open $file r]
      a read end $f 503
      close $f
      a get 500 502
    }

performTest read.ok2 $errFalse \
    {998 999 100 1000}\
    {
      global file
      Int a
      set f [open $file r]
      a read end $f 200
      a read 100 $f 20000
      close $f
      set x "[a get 898 900] [a length]"
    }

performTest read.ok3 $errFalse \
    {998 999 100 1000}\
    {
      global file
      Int a
      set f [open $file r]
      a read end $f 200
      a read 100 $f 10000
      close $f
      set x "[a get 898 900] [a length]"
    }


exec rm -f $file
