set errTrue 1
set errFalse 0

########################################################################
## Test of trunc command

performTest trunc.wrong-num-args $errTrue \
    "wrong \# args: should be `a trunc length'" \
    {UShort a; a trunc}

performTest trunc.wrong-index $errTrue \
    {index out of range: `5'} \
    {UShort a; a insert end "1 2 3"; a trunc 5}

performTest trunc.ok1 $errFalse \
    {3 1} \
    {
      UShort a;
      a insert end "1 2 3"; 
      set x "[a trunc 1] [a length]"
    }

performTest trunc.ok2 $errFalse \
    {19 5} \
    {
      UShort a;
      a insert end "1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19"; 
      set x "[a trunc 5] [a length]"
    }

performTest trunc.ok3 $errFalse \
    {100 55} \
    {
      UShort a;
      for {set i 0} {$i<100} {incr i} {a insert end $i}
      set x "[a trunc 55] [a length]"
    }

performTest trunc.ok4 $errFalse \
    {100 11} \
    {
      UShort a;
      for {set i 0} {$i<100} {incr i} {a insert end $i}
      set x "[a trunc 11] [a length]"
    }

