/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <stdlib.h>
#include <bitaP.h>


/**********************************************************************/
void
bitaFree(Bita b)
{
  free((char*)b->v);
  free((char*)b);
}
/**********************************************************************/
/*
  If a Bita is very short compared to the memory it occupies, we try
  to realloc it.
*****/
void
bitaMaybeSqueeze(Bita b)
{
  char *tmp;

  if( b->size<16 ) return;

  if( b->size<64 && b->length>b->size/4 ) return;

  if( b->length > b->size/2 ) return;

  tmp = realloc(b->v, (8+b->length)*b->class->elemSize);
  if( !tmp ) return;

  b->v = tmp;
  b->size = b->length+8;
}
/**********************************************************************/
