/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
/*****
  binary typed arrays for tcl
*****/
#ifndef __bita__
#define __bita__

#include <tcl.h>

/*****
  Every bita-type is described by a class structure.
*****/
typedef struct s_BitaClass {
  char *name;		/* name used to create an array of the new type */
  unsigned elemSize;	/* size of one array element */
  void (*elemToString)(void *, Tcl_DString *result);
  int (*stringToElem)(char *s, void *elem, Tcl_Interp *ip);
#if SIGPROC
  void (*minmax)(void *elem, unsigned count, void **minP, void **maxP);
#endif
} BitaClass;
	   
typedef struct s_Bita {
  BitaClass *class;
  unsigned size;	/* number of allocated elements */
  unsigned length;	/* number of current elements */
  char *v;
} *Bita;
/**********************************************************************/
/* The following classes are supported by the base distribution */

extern BitaClass bitaUShortClass;
extern BitaClass bitaShortClass;
extern BitaClass bitaUnsignedClass;
extern BitaClass bitaIntClass;
extern BitaClass bitaFloatClass;
extern BitaClass bitaDoubleClass;

/**********************************************************************/




extern void bitaFree(Bita b);

extern void bitaMaybeSqueeze(Bita b);

extern int bitaNewCmd(ClientData _class,
		     Tcl_Interp *ip,
		     int argc, char **argv);

extern int BitaInit(Tcl_Interp *ip);



#endif
