/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <string.h>

#include <bitaP.h>

typedef int (*cmdFunc)(Bita, Tcl_Interp*, 
		       const int, char **);
typedef struct s_bitaCmdType {
  char *name;
  cmdFunc cmd;
} bitaCmdType;

static bitaCmdType bitaCmds[] = {
  {"copy", bitaCopyCmd},
  {"get", bitaGetCmd},
#if SIGPROC
  {"minmax", bitaMinmaxCmd},
#endif
  {"insert", bitaInsertCmd}, /* if name changed, see also InsertCmd */
  {"length", bitaLengthCmd},
  {"pop", bitaPopCmd},
  {"push", bitaPushCmd},
  {"read", bitaReadCmd},
  {"remove", bitaGetCmd}, /* if name changed, see also GetCmd */
  {"set", bitaInsertCmd}, /* if name changed, see also InsertCmd */
  {"swap", bitaSwapCmd},
  {"trunc", bitaTruncCmd},
  {"type", bitaTypeCmd},
  {"write", bitaWriteCmd},
  {NULL, NULL}
};

/**********************************************************************/
int
bitaCmd(ClientData _b,
	Tcl_Interp *ip,
	int argc,
	char **argv)
{
  bitaCmdType *p;

  if( argc<2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `", 
		     argv[0],
		     " option ?arg ...?'", NULL);
    return TCL_ERROR;
  }
  
  /*****
    Could someone please implement a faster search?
  *****/
  for(p=bitaCmds; p->name; p++) {
    if( 0==strcmp(argv[1], p->name) ){
      return p->cmd(_b, ip, argc, argv);
    }
  }
  Tcl_AppendResult(ip, "bad option `", argv[1], "': must be ",
		   bitaCmds[0].name, NULL);
  for(p=bitaCmds+1; p->name; p++) {
    Tcl_AppendResult(ip, ", ", p->name, NULL);
  }
  return TCL_ERROR;
}

