/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <errno.h>
#include <float.h>
#include <ctype.h>
#include <math.h>

#include <bita.h>

/**********************************************************************/
static void
doubleElemToString(void *_f, Tcl_DString *result)
{
  /***** 
    Who is really able to figure out exactly, how many characters are
    at most generated from these dammed float conversion? All I
    understood is, that %f can generate quite a lot of digits, if the
    exponent is large, while %e is definitely limited by the
    precision. Finally %g combines the best of both worlds.
  *****/
  char buf[100];	/* This should be ok! */
  
  sprintf(buf, "%g", *((double*)_f) );
  Tcl_DStringAppendElement(result, buf);
}
/**********************************************************************/
static int
doubleStringToElem(char *s, void *_f, Tcl_Interp *ip)
{
  double res;
  char *endp;

  errno = 0;

  /***** This is an attempt to be really picky (using STDC) */
  res = strtod(s, &endp);
  if( endp != s ) {
    while( *endp && isspace(*endp) ) endp += 1;
  }

  if( 0!=errno ) {
    Tcl_AppendResult(ip, "double value out of range: `", NULL);
  } else if( *endp || s==endp) {
    Tcl_AppendResult(ip, "illegal double value: `", NULL);
  } else {
    *((double*)_f) = res;
    return TCL_OK;
  }
  Tcl_AppendResult(ip, s, "'", NULL);
  return TCL_ERROR;
}
/**********************************************************************/
#if SIGPROC
static void
doubleMinmax(void *_v, unsigned count, void **minP, void **maxP)
{
  unsigned i;
  double *v = (double *)_v;
  double min, max;

  *minP = *maxP = v;
  min = max = *v++;
  for(i=1; i<count; i++, v++) {
    if( *v<min ) {
      min = *v; 
      *minP = v;}
    else if( *v>max ) {
      max = *v;
      *maxP = v;
    }
  }
}
#endif
/**********************************************************************/

BitaClass bitaDoubleClass = {
  "Double",
  8,
  doubleElemToString,
  doubleStringToElem,
#if SIGPROC
  doubleMinmax
#endif 
};
