/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <errno.h>
#include <float.h>
#include <ctype.h>
#include <math.h>

#include <bita.h>

/**********************************************************************/
static void
floatElemToString(void *_f, Tcl_DString *result)
{
  /***** 
    Who is really able to figure out exactly, how many characters are
    at most generated from these dammed float conversion? All I
    understood is, that %f can generate quite a lot of digits, if the
    exponent is large, while %e is definitely limited by the
    precision. Finally %g combines the best of both worlds.
  *****/
  char buf[100];	/* This should be ok! */
  
  /***** 
    Now let's try to make use of our knowledge that
    a) _f points to a float
    b) STDC can only convert double
  *****/
  sprintf(buf, "%g", (double) *((float*)_f) );
  Tcl_DStringAppendElement(result, buf);
}
/**********************************************************************/
static int
floatStringToElem(char *s, void *_f, Tcl_Interp *ip)
{
  double res;
  char *endp;

  errno = 0;

  /***** This is an attempt to be really picky (using STDC) */
  res = strtod(s, &endp);
  if( endp != s ) {
    while( *endp && isspace(*endp) ) endp += 1;
  }

  /***** Shit on underflow. Zero is zero! */
  if( 0!=errno || fabs(res)>FLT_MAX ) {
    Tcl_AppendResult(ip, "float value out of range: `", NULL);
  } else if( *endp || s==endp) {
    Tcl_AppendResult(ip, "illegal float value: `", NULL);
  } else {
    /***** Ok now, we simply let the cast happen */
    *((float*)_f) = (float)res;
    return TCL_OK;
  }
  Tcl_AppendResult(ip, s, "'", NULL);
  return TCL_ERROR;
}
/**********************************************************************/
#if SIGPROC
static void
floatMinmax(void *_v, unsigned count, void **minP, void **maxP)
{
  unsigned i;
  float *v = (float *)_v;
  float min, max;

  *minP = *maxP = v;
  min = max = *v++;
  for(i=1; i<count; i++, v++) {
    if( *v<min ) {
      min = *v; 
      *minP = v;}
    else if( *v>max ) {
      max = *v;
      *maxP = v;
    }
  }
}
#endif
/**********************************************************************/

BitaClass bitaFloatClass = {
  "Float",
  4,
  floatElemToString,
  floatStringToElem,
#if SIGPROC
  floatMinmax
#endif
};
