/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <string.h>

#include <bitaP.h>
#include <util.h>

/**********************************************************************
   bitaGetCmd -- retrieve data from a bita and return it as
                 tcl-string. 
		 
		
   implements `get'- and `remove'-operations.
*****/
int
bitaGetCmd(Bita b,
	   Tcl_Interp *ip,
	   int argc,
	   char **argv)
{
  unsigned start, end;
  unsigned i;
  char *v;
  Tcl_DString dstr;

  if( argc>4 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `", 
		     argv[0], " ", argv[1],
		     " ?from? ?to?'", NULL);
    return TCL_ERROR;
  }


  if( 0==b->length ) {
    Tcl_AppendResult(ip, argv[0], " is empty", NULL);
    return TCL_ERROR;
  }

  if( argc>2 ) {
    if( !checkedIndex(ip, argv[2], &start, b->length-1) ) 
      return TCL_ERROR;
  } else {
    start = 0;
  }

  if( argc>3 ) {
    if( !checkedIndex(ip, argv[3], &end, b->length-1) )
      return TCL_ERROR;
    end += 1;
  } else {
    end = b->length;
  }

  if( start>end ) {
    Tcl_SetResult(ip, 
		  "`from'-index may not be greater than `to'-index",
		  TCL_STATIC);
    return TCL_ERROR;
  }

  /***** convert */
  Tcl_DStringInit(&dstr);
  for(i=start, v=b->v+(start*b->class->elemSize); 
      i<end; 
      i++, v+=b->class->elemSize) {
    b->class->elemToString(v, &dstr);
  }
  Tcl_DStringResult(ip, &dstr);

  /***** handling of remove-command */
  if( 0==strcmp(argv[1], "remove") ) {
    memmove(b->v+(start*b->class->elemSize),
	    b->v+(end*b->class->elemSize),
	    (b->length-end)*b->class->elemSize);
    b->length -= (end-start);
    bitaMaybeSqueeze(b);
  }

  return TCL_OK;
}
/**********************************************************************/
