/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <ctype.h>

#include <bita.h>

/**********************************************************************/
static void
intElemToString(void *_f, Tcl_DString *result)
{
  char buf[20];
  sprintf(buf, "%d", *((int*)_f) );
  Tcl_DStringAppendElement(result, buf);
}
/**********************************************************************/
static int
intStringToElem(char *s, void *_f, Tcl_Interp *ip)
{
  long int res;
  char *endp;

  errno = 0;

  /***** This is an attempt to be really picky (using STDC) */
  res = strtol(s, &endp, 0);
  if( endp!=s ) {
    while( *endp && isspace(*endp) ) endp += 1;
  }

  if( 0!=errno || res>INT_MAX || res<INT_MIN ) {
    Tcl_AppendResult(ip, "int value out of range: `", NULL);
  } else if( *endp || s==endp ) {
    Tcl_AppendResult(ip, "illegal int value: `", NULL);
  } else {
    *((int*)_f) = (int)res;
    return TCL_OK;
  }
  Tcl_AppendResult(ip, s, "'", NULL);
  return TCL_ERROR;
}
/**********************************************************************/
#if SIGPROC
static void
intMinmax(void *_v, unsigned count, void **minP, void **maxP)
{
  unsigned i;
  int *v = (int*)_v;
  int min, max;

  *minP = *maxP = v;
  min = max = *v++;
  for(i=1; i<count; i++, v++) {
    if( *v<min ) {
      min = *v; 
      *minP = v;}
    else if( *v>max ) {
      max = *v;
      *maxP = v;
    }
  }
}
#endif
/**********************************************************************/

BitaClass bitaIntClass = {
  "Int",
  4,
  intElemToString,
  intStringToElem,
#if SIGPROC
  intMinmax
#endif
};
