/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <bitaP.h>

/**********************************************************************
  bitaLengthCmd -- return length of bita

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "length"

  RETURN(tcl):
  -- number of values currently stored in bita

*****/
int
bitaLengthCmd(Bita b,
	      Tcl_Interp *ip,
	      int argc,
	      char **argv)
{
  static char buf[30];	/* enough for everthing %u might print */

  if( argc>2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0],
		     " length'", NULL);
    return TCL_ERROR;
  }
  
  sprintf(buf, "%u", b->length);
  Tcl_SetResult(ip, buf, TCL_STATIC);
  return TCL_OK;
}
/**********************************************************************/
