/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <string.h>

#include <bitaP.h>
#include <util.h>

#if SIGPROC
/**********************************************************************
  bitaMinmax -- compute minimum/maximum
		 
		
  implements minmax-operation
  <bita> minmax ?from? ?to?
*****/
int
bitaMinmaxCmd(Bita b,
	   Tcl_Interp *ip,
	   int argc,
	   char **argv)
{
  unsigned start, end;
  Tcl_DString dstr;
  void *minP, *maxP;

  if( !b->class->minmax ) {
    Tcl_AppendResult(ip,
		     argv[1], " not implemented for bita type ",
		     b->class->name, NULL);
    return TCL_ERROR;
  }

  if( argc>4 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `", 
		     argv[0], " ", argv[1],
		     " ?from? ?to?'", NULL);
    return TCL_ERROR;
  }


  if( 0==b->length ) {
    Tcl_AppendResult(ip, argv[0], " is empty", NULL);
    return TCL_ERROR;
  }

  if( argc>2 ) {
    if( !checkedIndex(ip, argv[2], &start, b->length-1) ) 
      return TCL_ERROR;
  } else {
    start = 0;
  }

  if( argc>3 ) {
    if( !checkedIndex(ip, argv[3], &end, b->length-1) )
      return TCL_ERROR;
    end += 1;
  } else {
    end = b->length;
  }

  if( start>end ) {
    Tcl_SetResult(ip, 
		  "`from'-index may not be greater than `to'-index",
		  TCL_STATIC);
    return TCL_ERROR;
  }

  /***** call minmax */
  b->class->minmax(b->v+(start*b->class->elemSize), end-start,
		   &minP, &maxP);

  /***** convert the values */
  Tcl_DStringInit(&dstr);
  b->class->elemToString(minP, &dstr);
  b->class->elemToString(maxP, &dstr);

  Tcl_DStringResult(ip, &dstr);

  return TCL_OK;
}
/**********************************************************************/
#else
/* To not have an empty compilation unit, we have this */
char * fizzlipuzzly ="holleriDiDudelDoe";
#endif

