/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>

#include <bitaP.h>

/**********************************************************************/
int
bitaNewCmd(ClientData _class,
	   Tcl_Interp *ip,
	   int argc,
	   char **argv)
{
  BitaClass *class = _class;
  int i;

  if( argc<2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `", 
		     argv[0],
		     " varName ?varName? ...'", NULL);
    return TCL_ERROR;
  }

  /***** generate a command for every name */
  for(i=1; i<argc; i++) {
    Bita b;

    /***** get the bita */
    b = (Bita)malloc(sizeof(struct s_Bita));
    if( !b ) {
      Tcl_SetResult(ip, "out of memory", TCL_STATIC);
      return TCL_ERROR;
    }
    b->class = class;
    b->size = 0;
    b->length = 0;
    b->v = NULL;

    /***** Generate the command */
    (void)Tcl_CreateCommand(ip, argv[i], bitaCmd, b, 
			    (Tcl_CmdDeleteProc*)bitaFree);
  }
  return TCL_OK;
}

			     

  
