/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <bitaP.h>

/**********************************************************************
  bitaPopCmd -- return last element of bita and reduce length by one.

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "pop"

  RETURN(tcl):
  -- last value

*****/
int
bitaPopCmd(Bita b,
	   Tcl_Interp *ip,
	   int argc,
	   char **argv)
{
  Tcl_DString dstr;
  unsigned eS = b->class->elemSize;

  if( argc>2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0],
		     " pop'", NULL);
    return TCL_ERROR;
  }

  if( 0==b->length ) {
    Tcl_AppendResult(ip, argv[0], " is empty", NULL);
    return TCL_ERROR;
  }

  b->length -= 1;
  Tcl_DStringInit(&dstr);
  b->class->elemToString(b->v + eS*b->length, &dstr);
  Tcl_DStringResult(ip, &dstr);

  return TCL_OK;
}
/**********************************************************************/
