/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>

#include <bitaP.h>

/**********************************************************************
  bitaPushCmd -- append one element to a bita

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "push" value

  RETURN(tcl):
  -- name of bita, i.e. argv[0]

*****/
int
bitaPushCmd(Bita b,
	    Tcl_Interp *ip,
	    int argc,
	    char **argv)
{
  unsigned elemSize = b->class->elemSize;

  if( argc!=3 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0],
		     " push value'", NULL);
    return TCL_ERROR;
  }

  if( b->length>=b->size ) {
    unsigned newSize;
    char *tmp;
    if( b->size>100 ) newSize = b->length+100;
    else newSize = 2*(b->length+2);
    tmp = realloc(b->v, elemSize*newSize);
    if( !tmp && 
	!(tmp=realloc(b->v, elemSize*(newSize=b->length+1))) ) {
      Tcl_SetResult(ip, "out of memory", TCL_STATIC);
      return TCL_ERROR;
    }
    b->v = tmp;
    b->size = newSize;
  }

  if( TCL_OK!=b->class->stringToElem(argv[2], 
				     b->v+elemSize*b->length, 
				     ip) ) return TCL_ERROR;
  b->length += 1;
  Tcl_SetResult(ip, argv[0], TCL_VOLATILE);
  return TCL_OK;
}
/**********************************************************************/

