/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include <ctype.h>

#include <bita.h>

/**********************************************************************/
static void
shortElemToString(void *_f, Tcl_DString *result)
{
  char buf[20];
  sprintf(buf, "%hd", *((short*)_f) );
  Tcl_DStringAppendElement(result, buf);
}
/**********************************************************************/
static int
shortStringToElem(char *s, void *_f, Tcl_Interp *ip)
{
  long int res;
  char *endp;

  errno = 0;

  /***** This is an attempt to be really picky (using STDC) */
  res = strtol(s, &endp, 0);
  if( endp != s ) {
    while( *endp && isspace(*endp) ) endp += 1;
  }

  if( 0!=errno || res>SHRT_MAX || res<SHRT_MIN ) {
    Tcl_AppendResult(ip, "short value out of range: `", NULL);
  } else if( *endp || s==endp ) {
    Tcl_AppendResult(ip, "illegal short value: `", NULL);
  } else {
    *((short*)_f) = (short)res;
    return TCL_OK;
  }
  Tcl_AppendResult(ip, s, "'", NULL);
  return TCL_ERROR;
}
/**********************************************************************/
#if SIGPROC
static void
shortMinmax(void *_v, unsigned count, void **minP, void **maxP)
{
  unsigned i;
  short *v = (short*)_v;
  short min, max;

  *minP = *maxP = v;
  min = max = *v++;
  for(i=1; i<count; i++, v++) {
    if( *v<min ) {
      min = *v; 
      *minP = v;}
    else if( *v>max ) {
      max = *v;
      *maxP = v;
    }
  }
}
#endif
/**********************************************************************/

BitaClass bitaShortClass = {
  "Short",
  2,
  shortElemToString,
  shortStringToElem,
#if SIGPROC
  shortMinmax
#endif
};
