/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996,1997 Harald Kirsch (kir@iitb.fhg.de)

  $Revision: 1.1 $, $Date: 1997/04/21 06:08:50 $
**********************************************************************/
#include <string.h>
#include <stdlib.h>
#include <bitaP.h>
#include <util.h>
/**********************************************************************
  bitaSwapCmd -- swap bytes or words to switch between big- and
  little-endian 

  SYNOPSIS:
  bita "swap"

  RETURN(tcl)
  -- the empty string
*****/int
bitaSwapCmd(Bita b,
	    Tcl_Interp *ip,
	    int argc,
	    char **argv)
{
  unsigned i;
  unsigned elemSize = b->class->elemSize;
  char *s;

  if( argc>2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0], " swap'", NULL);
    return TCL_ERROR;
  }

  for(i=0, s=b->v; i<b->length; i++, s+=elemSize) {
    unsigned k;
    for(k=0; k<elemSize/2; k++) {
      char tmp = s[k];
      s[k] = s[elemSize-1-k];      
      s[elemSize-1-k] = tmp;
    }
  }

  Tcl_SetResult(ip, "", TCL_STATIC);
  return TCL_OK;
}
