/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>

#include <bitaP.h>
#include <util.h>

/**********************************************************************
  bitaTruncCmd -- truncate bita to given length

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "trunc" length

  RETURN(tcl):
  -- number of values before truncation

*****/
int
bitaTruncCmd(Bita b,
	     Tcl_Interp *ip,
	     int argc,
	     char **argv)
{
  static char buf[30];	/* enough for everthing %u might print */
  unsigned newLen;

  if( argc!=3 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0],
		     " trunc length'", NULL);
    return TCL_ERROR;
  }
  

  if( !checkedIndex(ip, argv[2], &newLen, b->length) )
    return TCL_ERROR;

  sprintf(buf, "%u", b->length);
  b->length = newLen;
  bitaMaybeSqueeze(b);

  Tcl_SetResult(ip, buf, TCL_STATIC);
  return TCL_OK;
}
/**********************************************************************/
