/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <bitaP.h>

/**********************************************************************
  bitaTypeCmd -- return type of bita

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "length"

  RETURN(tcl):
  -- number of values currently stored in bita

*****/
int
bitaTypeCmd(Bita b,
	    Tcl_Interp *ip,
	    int argc,
	    char **argv)
{
  if( argc>2 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0], " ", argv[1], "'", NULL);
    return TCL_ERROR;
  }
  
  Tcl_SetResult(ip, b->class->name, TCL_STATIC);
  return TCL_OK;
}
/**********************************************************************/
