/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include <ctype.h>

#include <bita.h>
/**********************************************************************/
static void
ushortElemToString(void *_f, Tcl_DString *result)
{
  char buf[20];
  sprintf(buf, "%hu", *((unsigned short*)_f) );
  Tcl_DStringAppendElement(result, buf);
}
/**********************************************************************/
static int
ushortStringToElem(char *s, void *_f, Tcl_Interp *ip)
{
  unsigned long res;
  char *endp;

  errno = 0;

  /***** This is an attempt to be really picky (using STDC) */
  res = strtoul(s, &endp, 0);
  if( endp != s) {
    while( *endp && isspace(*endp) ) endp += 1;
  }

  if( 0!=errno || res>USHRT_MAX ) {
    Tcl_AppendResult(ip, "unsigned short value out of range: `",
		     NULL);
  } else if ( *endp || s==endp ) {
    Tcl_AppendResult(ip, "illegal unsigned short value: `", NULL);
  } else {
    *((unsigned short*)_f) = (unsigned short)res;
    return TCL_OK;
  }

  Tcl_AppendResult(ip, s, "'", NULL);
  return TCL_ERROR;
}
/**********************************************************************/
#if SIGPROC
static void
ushortMinmax(void *_v, unsigned count, void **minP, void **maxP)
{
  unsigned i;
  unsigned short *v = (unsigned short*)_v;
  unsigned short min, max;

  *minP = *maxP = v;
  min = max = *v++;
  for(i=1; i<count; i++, v++) {
    if( *v<min ) {
      min = *v; 
      *minP = v;}
    else if( *v>max ) {
      max = *v;
      *maxP = v;
    }
  }
}
#endif
/**********************************************************************/

BitaClass bitaUShortClass = {
  "UShort",
  2,
  ushortElemToString,
  ushortStringToElem,
#if SIGPROC
  ushortMinmax
#endif
};
