/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <stdio.h>
#include <malloc.h>	/* buggy tcl.h does not include this although
			   it defines Tcl_Result to use free() */
#include <bitaP.h>
#include <util.h>

/**********************************************************************
  bitaWriteCmd -- write values from a bita in binary to file

  Called from bitaCmd according to argv[1]. The bita comes in
  ClientData. 

  SYNOPSIS:
  bita "write" file ?from? ?to?

  If `from' and `to' are not given they default to 0 and `end'
  respectively. 

  RETURN(tcl):
  -- number of values written.
*****/
int
bitaWriteCmd(Bita b,
	     Tcl_Interp *ip,
	     int argc,
	     char **argv)
{
  unsigned elemSize = b->class->elemSize;
  int mode;
  static char buf[30];	/* enough for everthing %u might print */

  unsigned start, end;
  int byteCount;
  Tcl_Channel file;

  /***** BEGIN */
  if( argc<3 ) {
    Tcl_AppendResult(ip, 
		     "wrong # args: should be `",
		     argv[0],
		     " write file ?from? ?to?'", NULL);
    return TCL_ERROR;
  }

  if( 0==b->length ) {
    Tcl_AppendResult(ip, argv[0], " is empty", NULL);
    return TCL_ERROR;
  }

  /***** get the file */
  file = Tcl_GetChannel(ip, argv[2], &mode);
  if( !file) {
    return TCL_ERROR;
  }
  if( !(mode&TCL_WRITABLE) ) {
    Tcl_AppendResult(ip, "channel `", argv[2], 
		     "' wasn't opened for writing", NULL);
    return TCL_ERROR;
  }

  /***** start-index */
  if( argc>3 ) {
    if( !checkedIndex(ip, argv[3], &start, b->length-1) ) 
      return TCL_ERROR;
  } else {
    start = 0;
  }

  /***** end-index */
  if( argc>4 ) {
    if( !checkedIndex(ip, argv[4], &end, b->length-1) )
      return TCL_ERROR;
    end += 1;
  } else {
    end = b->length;
  }

  if( start>end ) {
    Tcl_SetResult(ip, 
		  "`from'-index may not be greater than `to'-index",
		  TCL_STATIC);
    return TCL_ERROR;
  }
	
  /***** WRITE */
  if( TCL_OK!=bitaSetChannelMode(ip, file) ) return TCL_ERROR;
  byteCount = 
    Tcl_Write(file, b->v+(start*elemSize), elemSize*(end-start));
  if( TCL_OK!=bitaSetChannelMode(ip, file) ) {
    if( byteCount>=0 ) return TCL_ERROR;
  }

  if( byteCount<0 ) {
    Tcl_FreeResult(ip);
    Tcl_AppendResult(ip, "error writing `",
		     argv[2], "': ",
		     Tcl_PosixError(ip), NULL);
    return TCL_ERROR;
  }

  sprintf(buf, "%d", byteCount/elemSize);
  Tcl_SetResult(ip, buf, TCL_STATIC);

  return TCL_OK;
}
/**********************************************************************/
