#!/bin/csh -fe

#set echo

## make all the directories we need
foreach x ($BINDIR $LIBDIR $MANNDIR $MAN3DIR $DOCDIR $INCDIR)
  set y = ""
  while ( ! -d $x ) 
    set y = $y/$x:t
    set x = $x:h
  end
  while ( $y != "" )
    set x = $x/$y:t
    set y = $y:h
    mkdir $x
  end
end

## first the easy copying stuff
echo "copying binaries, libs, includes and change notes"
cp tclbsh bwish t2a	$BINDIR
chmod 755 $BINDIR/{tclbsh,bwish,t2a}
cp libbita.* {tcl,tk}AppInit.c	$LIBDIR
cp bita*.h		$INCDIR
cp CHANGES		$DOCDIR

## the manual pages get their version inserted
echo "sedding manual pages"
foreach x (man/*.n)
  set y = $x:t
  sed -e "1,30s/@Version@/$VERSION/" $x > $MANNDIR/$y
end
foreach x (man/*.3)
  set y = $x:t
  sed -e "1,30s/@Version@/$VERSION/" \
      -e "s,@libdir@,$LIBDIR,g"    \
      -e "s,@incdir@,$INCDIR,g"    \
      $x > $MAN3DIR/$y
end


##
## now try to install convenience links
##
./clink.sh $LROOT/bin $BINDIR/{tclbsh,bwish,t2a}
./clink.sh $LROOT/lib $LIBDIR/libbita.*
./clink.sh $LROOT/include $INCDIR/bita*.h
./clink.sh $LROOT/man/mann $MANNDIR/bita.n
./clink.sh $LROOT/man/man3 $MAN3DIR/bita.3


##### end #####
