.\" (c) 1994 by Harald Kirsch (kir@iitb.fhg.de)
.\"
.\" $Id: bita.n,v 1.1.1.1 1997/03/29 17:24:44 kir Exp $
.\"
.\" HISTORY:
.\" $Log: bita.n,v $
.\" Revision 1.1.1.1  1997/03/29 17:24:44  kir
.\" Initial checkin of a running version. However, I am going to dig after a
.\" minor bug in conjunction with bita read.
.\"
.\"
.\" -----------------------------------------------------------------
.TH BITA N  "@Version@" "Kir" "TCL/TK Extension Manual"
.SH NAME
Bita \- 
.BR Bi nary
.BR T yped
.BR A rrays
for Tcl/Tk

.SH SYNOPSIS
.B Short
.I "name ?name ...?"

.B UShort
.I "name ?name ...?"

.B Int
.I "name ?name ...?"

.B Unsigned
.I "name ?name ...?"

.B Float
.I "name ?name ...?"

.B Double
.I "name ?name ...?"


.\"*********************************************************************
.SH DESCRIPTION
The Tcl/Tk-extension 
.B Bita
implements binary typed arrays with dynamic length. Access to and
handling of Bitas is quite similar to the handling of
widgets in Tk. The new Tcl-commands 
.BR Short ,
.BR UShort ,
.BR Int ,
.BR Unsigned ,
.BR Float " and " Double
create for each of their
.IR name -arguments
a binary array with the obvious type and bind it to
.IR name .
All commands return the empty string. If a given 
.IR name -argument
exists before as a Tcl-procedure, the procedure is deleted. The same
applies, if the 
.IR name -argument
denotes an already existing Bita.

Bitas are designed to efficiently store and manipulate large numbers of
binary values of a given type. Initially, a Bita contains no values and
has length zero. As values are added or deleted, the length varies
accordingly.

Many Bita-subcommands (see below) require one or two index-parameters
denoting the part of the Bita on which the command operates. As a
general rule, an index-pair is always interpreted as a
closed interval, i.e. the command

.RS
bla get 7 10
.RE

returns the values at indices 7, 8, 9 and 10 of
.BR bla .
In general, all indices must be greater than or equal to zero and less
than the current length of the Bita. The word
.BR end ,
when used as the upper bound of an interval, denotes the index of the
last element of the Bita. However when used as the destination index
of some operation (e.g. copy), it denotes the index position after the
last element of the Bita. (Don't worry, it usually comes out quite
right.)

.SH
BITA COMMAND
The commands listed above create new Tcl commands whose names are the
.IR name s
listed as their parameters. These commands may be used to invoke
various operations on their associated Bita. They have the following
general form:

.RS
.I "name cmd ?arg arg ...?"	
.RE

.I Cmd
and the
.IR arg s
determine the exact behaviour of the command. The following commands are
possible for all types of Bitas:

.\" -----------------------------------------------------------------
.TP
.IB name " copy " "dstIndex srcBita ?from? ?to?"
Copy values from one bita into another. The parameter
.I srcBita
must be a Bita of the same type as
.IR name .
If
.IR from " and " to
are not given, all values of
.I srcBita
are inserted at position
.I dstIndex
into
.IR name ,
i.e. all values of
.I name
after and including the value at
.I dstIndex
are first moved towards higher index positions and then the values of
.I srcBita
are copied into the resulting gap. If 
.IR from " and " to 
are given, the operation is performed only on the specified part of
.IR srcBita .  
If only
.I to
is omitted, it defaults to
.BR end .
The command returns
.IR name .

.\" -----------------------------------------------------------------
.TP
.IB name " get " "?from? ?to?"
Convert binary values to their string represention. If neither
.IR from " nor " to
are given, the command returns a Tcl list containing the
string representations of all values of
.IR name .
If both,
.IR from " and " to
are given, only that part of
.I name
is converted and returned. If only
.I from
is given,
.I to
defaults to
.BR end . 
.B WARNING:
Please remember that the result may be a rather long string, if
.I name
is large.


.\" -----------------------------------------------------------------
.TP
.IB name " insert " "dstIndex values"
Convert 
.I values
to binary and insert them into
.IR name .
The elements of the Tcl-list
.I values
must be valid string-representations of values of the type storeable
in
.IR name .
They are converted to binary and inserted into 
.I name
at position 
.IR dstIndex ,
i.e. all values at positions above and including 
.I dstIndex
are shifted to higher index-positions and the converted
.I values
are entered into the resulting gap.


.\" -----------------------------------------------------------------
.TP
.IB name " length"
returns the number of values currently stored in 
.IR name .

.\" -----------------------------------------------------------------
.TP 
.TP
.IB name " minmax " "?from? ?to?"
Compute minimum and maximum of
.IR name .
If neither
.IR from " nor " to
are given, the command computes the maximum of all values in
.IR name .
If both,
.IR from " and " to
are given, only that part of
.I name
is considered. If only
.I from
is given,
.I to
defaults to
.BR end . 
In all cases, a tcl-list containing two values is returned. The first
is the minimum and the second the maximum.
.RB ( Minmax
is only available if the package was compiled with 
.BR -DSIGPROC .)

.\" -----------------------------------------------------------------
.TP
.IB name " pop "
Return the string-representation of the last element of 
.I name
and remove it from
.IR name .
If no values are currently stored in name, an error is generated.


.\" -----------------------------------------------------------------
.TP
.IB name " push " value
Convert
.I value
to binary and append it to 
.IR name .
.I Value
must be the string-representation of a value of the type storeable in
.IR name .
(To append more than one value, use
.B insert
with
.I dstIndex
set to
.BR end .


.\" -----------------------------------------------------------------
.TP
.IB name " read " "dstIndex file count"
Read binary values from a file and insert them into 
.IR name .
The parameter
.I file
must denote a file previously openend with
.IR open .
.I Count
values are read from the file, if available. 

If the file does
not contain enough values, or if the file is in non-blocking mode (see
.BR fconfigure (n)),
fewer values might be read. The number of values actually read is
returned, but read on:
Additionally, the inner workings of Tcl may result in incomplete
values being read, e.g. only 2 bytes of a 4 byte integer. In this
case, a list is returned. Its first element is the number of full
values read and inserted into the bita. The following elements are the
numerical values (in ascii) of the additional bytes. 

Example: A return value of {3 65 9} means that three full values have
been read and inserted into the bita and that only two bytes of the
fourth value arrived, having the value 65 and 9.

As for 
.BR copy " and " insert ,
the values read are inserted into
.IR name ,
i.e. all values at or above
.I dstIndex
are shifted towards higher index-positions before reading. To append
the values read to
.IR name ,
use
.B end
as
.IR dstIndex .

.\" -----------------------------------------------------------------
.TP
.IB name " remove " "?from? ?to?
Remove binary values from 
.I name
and return the list of their string-representations. The
remove-operation is similar to the get-operation in that it converts
either all or the given range of values of
.I name
to their string representations. However, as a side effect, the values
converted are removed from
.IR name ,
thereby reducing the length accordingly.

.\" -----------------------------------------------------------------
.TP
.IB name " set " "dstIndex newValues"
Starting at
.IR dstIndex ", the "
current values of
.I name
are replaced by 
.IR newValues .
.I DstIndex
must be a valid index, i.e. it must be
.B end
or a nonnegative integer smaller then the current length of 
.IR name .
If 
.I newValues
contains more values than are left between
.I dstIndex
and the end of
.IR name ,
.I name
is enlarged accordingly, i.e. its length will be greater afterwards.


.\" -----------------------------------------------------------------
.TP
.IB name " trunc " length
Truncates
.I name
to the given 
.IR length .
All values at or above index-position
.I length
are removed from
.I name
and the memory is eventually released.

.\" -----------------------------------------------------------------
.TP
.IB name " write " "file ?from? ?to?
Write binary data to
.I file
.RB ( fwrite (3)
is used internally). The parameter
.I file
must denote a file previously opened with
.BR open .
If 
.IR from " and " to
are not given, all values of
.I name
are written. If only
.I from 
is given,
.I to
defaults to
.BR end .
The command returns the number of values actually written.

.SH REMARK
Read the manual page
.BR bita (3)
to find out how to build your own extended tclsh and wish containing
the bita capabilities.

.SH BUGS
It ist not possible to change the format which defines how to convert
binary data to ascii.

.\"*********************************************************************
.SH "SEE ALSO"
.BR Tcl (n),
.BR Tk (n),
.BR bita (3),
.BR fread (3),
.BR fwrite (3),
.BR open (n),
.BR tclsh (1),
.BR wish (1).
