#!/bin/csh -f

##### handle command line to set variables releaseType and dstDir
if( $#argv > 2 ) then 
usage:
  echo "usage: $0 [-minor|-major] [destdir]"
  echo "     -minor: this is a minor release, i.e. compatible"
  echo "     -major: this is a major release, i.e. incompatible"
  echo "             default is bugfix release"
  echo "    destDir: the directory where to put the .tar.gz-file"
  exit 1
endif

while( $#argv > 0 ) 
  switch( $1 )
  case -major:
    if( $?releaseType ) goto usage
    set releaseType = major
    breaksw

  case -minor:
    if( $?releaseType ) goto usage
    set releaseType = minor
    breaksw

  case -*:
    goto usage
    breaksw

  default:
    if( $?dstDir ) goto usage
    set dstDir $1
  endsw
  shift
end
if( ! $?releaseType ) set releaseType = bugfix 
if( ! $?dstDir ) set dstDir = /home1/kir/tools/gz


##### create version date string
set verdate = `date +%Y-%m-%d`

##### fetch previous version number and date from Makefile.in.
set version = `sed -n -e '/^VERSION =/s/.*= //p' Makefile.in`
set olddate = `sed -n -e '/^VERDATE =/s/.*= //p' Makefile.in`
echo $olddate

##### If this is a bugfix release and there was another release
##### already today, we don't care to increment the bugfix version
##### number. 
if( $releaseType == bugfix  &&  $olddate == $verdate ) goto EDIT

##### Increment release number
set bugfix = $version:e; set version = $version:r
set minor = $version:e; set version = $version:r
if( $releaseType == major ) then
  @ version = $version + 1
  set version = $version.0.0
else if( $releaseType == minor ) then
  @ minor = $minor + 1
  set version = $version.$minor.0
else 
  @ bugfix = $bugfix + 1
  set version = $version.$minor.$bugfix
endif


##### enter the version and verdate into Makefile.in
cp Makefile.in Makefile.in.orig
sed -e '/^VERDATE =/s/[0-9][0-9-]*/'$verdate/ \
    -e '/^VERSION =/s/[0-9][0-9.]*/'$version/ \
     Makefile.in.orig \
  >Makefile.in
rm -f Makefile.in.orig

##### lets write some notes
touch CHANGES
echo "***** $version ($verdate)" >CHANGES.tmp
echo "" >>CHANGES.tmp
cat CHANGES >>CHANGES.tmp
mv -f CHANGES.tmp CHANGES

EDIT:
vi CHANGES


##### lets have a clean .depend-file
mv .depend depend.orig
touch .depend



##### deduce the name of this package from cwd
set name = $cwd:t


##### remove old pack
rm -f $name-$version.tar.gz


##### the tar is made from the parent directory
cd ..
if ( ! -d $name ) then
  echo "${0}: something is wrong, perhaps a misleading soft link."
  echo "    After changing dir to '..', there is no dir '$name'."
  exit 1
endif

##### generate exclude file
rm -f .exclude
echo $name/.exclude >$name/.exclude
echo $name/$name-$version.tar.gz >>$name/.exclude

find $name \( \
	-name '*.tar.gz'  \
	-o -name '*~'     \
	-o -name '#*'     \
	-o -name core     \
	-o -name '*.[ao]' \
        -o -name '*.orig' \
        -o -name '*.so.*' \
	-o -name '?akefile' \
	-o -name 'config.*' \
	-o \( -perm -100 -a \! -type d -a -size +100k \) \
        \) -print \
	>>$name/.exclude

tar cfXv - $name/.exclude $name |gzip >$dstDir/$name-$version.tar.gz
echo "${0}: excluded files are listed in .exclude"

##### clean up
mv $name/depend.orig $name/.depend

##### end #####
