/**********************************************************************
  
  This file is part of the Bita-package, a Tcl/Tk-extension
  implementing binary typed array.

	 Copyright 1995,1996 Harald Kirsch (kir@iitb.fhg.de)

**********************************************************************/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

#include <tcl.h>

#include <util.h>

static Tcl_DString dstr1, dstr2;

/**********************************************************************/
char 
pickyUnsigned(char *s, unsigned long *res)
/*****
  Do a really picky conversion of a string to an unsigned.
*****/
{
  char *endp;

  errno = 0;
  *res = strtoul(s, &endp, 0);
  if( endp != s ) {
    while( *endp && isspace(*endp) ) endp += 1;
  }
  if( 0!=errno || *endp || s==endp ) return 1;

  return 0;
}
/**********************************************************************/
int
checkedIndex(Tcl_Interp *ip,
	     char *s, unsigned *index, unsigned max)
{
  unsigned long res;

  if( 0==strcmp(s, "end") ) {
    *index = max;
    return 1;
  }

  if( pickyUnsigned(s, &res) ) {
    Tcl_AppendResult(ip, "illegal index value: `", s, "'", NULL);
    return 0;
  } else if( res>(unsigned long)max ) {
    Tcl_AppendResult(ip, "index out of range: `", s, "'",
		     NULL);
    return 0;
  }
  *index = (unsigned)res;

  return 1;
}
/**********************************************************************/
int
bitaSetChannelMode(Tcl_Interp *ip, Tcl_Channel file)
{
  Tcl_DStringInit(&dstr1);
  if( TCL_OK!=Tcl_GetChannelOption(file, "-translation", &dstr1) ) {
    goto error;
  }
  Tcl_DStringInit(&dstr2);
  if( TCL_OK!=Tcl_GetChannelOption(file, "-eofchar", &dstr2) ) {
    goto error;
  }
  if( TCL_OK!=Tcl_SetChannelOption(ip, file, "-translation", "binary") ) {
    goto error;
  }
  return TCL_OK;

error:
  Tcl_DStringFree(&dstr1);
  Tcl_DStringFree(&dstr2);
  return TCL_ERROR;
}
/**********************************************************************/
int
bitaResetChannelMode(Tcl_Interp *ip, Tcl_Channel file)
{
  /***** Reset the channel mood */
  if( TCL_OK!=Tcl_SetChannelOption(ip, file, "-translation", 
				   Tcl_DStringValue(&dstr1)) ) {
    /*fprintf(stderr, "%s\n",  Tcl_DStringValue(&dstr1));*/
    goto error;
  }
  if( TCL_OK!=Tcl_SetChannelOption(ip, file, "-eofchar", 
				   Tcl_DStringValue(&dstr2)) ) {
    /*fprintf(stderr, "%s\n",  Tcl_DStringValue(&dstr2));*/
    goto error;
  }
  Tcl_DStringFree(&dstr1);
  Tcl_DStringFree(&dstr2);
  return TCL_OK;

error:
  Tcl_DStringFree(&dstr1);
  Tcl_DStringFree(&dstr2);
  return TCL_ERROR;
}
/**********************************************************************/
