# jdoc_hypertext.tcl - hypertext procedures for jdoc
#
######################################################################
# Copyright 1992-1996 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

##############################################################################
# jdoc:x_link w x y - go to link clicked on (hypertext)
##############################################################################

proc jdoc:x_link { {w} {x} {y} args } {
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find topic-name tag
    if {[string match "jdoc:link:*" $tag]} {
      set link [string range $tag 10 end]	;# strip off "jdoc:link:"
      if {[string match "#*" $link]} {		;# anchor within this doc
        set anchor [string trimleft $link "#"]
        jdoc:go_to_anchor $anchor $w $x $y
      } else {					;# separate doc
        if {[regexp -- {^http:|^file:|^ftp:} $link]} {
          j:view_url $link
        } else {
          exec jdoc $link &
        }
      }
      break
    }
  }
}

##############################################################################
# jdoc:x_topic w x y - view doc clicked on (hypertext)
##############################################################################

proc jdoc:x_topic { {w} {x} {y} args } {
  puts stderr "Warning: obsolete procedure jdoc:x_topic invoked."
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find topic-name tag
    if {[string match "jdoc:topic:*" $tag]} {
      set topic [string range $tag 11 end]	;# strip off "jdoc:topic:"
      exec jdoc $topic &
      break
    }
  }
}

##############################################################################
# jdoc:x_section w x y - go to section name clicked on (hypertext)
##############################################################################

proc jdoc:x_section { {w} {x} {y} args } {
  puts stderr "Warning: obsolete procedure jdoc:x_section invoked."
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find section-name tag
    if {[string match "jdoc:section:*" $tag]} {
      set section [string range $tag 13 end]	;# strip off "jdoc:section:"
      .menu.sections.m invoke $section
      break
    }
  }
}

##############################################################################
# jdoc:x_manpage w x y - view man page name clicked on (hypertext)
##############################################################################

proc jdoc:x_manpage { {w} {x} {y} args } {
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find manpage-name tag
    if {[string match "jdoc:manpage:*" $tag]} {
      set manpage [string range $tag 13 end]	;# strip off "jdoc:manpage:"
      j:view_man $manpage
      break
    }
  }
}

######################################################################
# jdoc:go_to_anchor anchor w x y - go to a particular anchor
######################################################################

proc jdoc:go_to_anchor { anchor w args } {
  if {[catch {$w yview jdoc:anchorname:${anchor}.first}]} {
    j:alert -text "Unable to find anchor `${anchor}' in this document."
  }
}
