# jedit_tags.tcl - text tag-manipulation routines for jedit, a tk-based editor
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# font commands - these set the font (tag list) for typing.
#   also, if there is a selection, and the insertion point is in it
#   or abuts it, the selection is set to the specified font.
# NOTE: fonts are registered in jedit_cmds.tcl
######################################################################

######################################################################
# jedit:set_tags t tags - general routine to do the above for any tag
######################################################################

proc jedit:set_tags { t args } {
  foreach tag $args {
    j:tag:set_tag $t $tag
  }
  if [j:text:insert_touches_selection $t] {
    foreach tag $args {
      j:tag:tag_text $t $tag sel.first sel.last
    }
  }
}

######################################################################
# jedit:clear_tags t patterns - 
#   remove tags matching any pattern from tag list, and if appropriate,
#   from selection
######################################################################

proc jedit:clear_tags { t args } {
  foreach pattern $args {
    j:tag:clear_tag $t $pattern
  }
  if [j:text:insert_touches_selection $t] {
    foreach pattern $args {
      j:tag:untag_text $t $pattern sel.first sel.last
    }
  }
}

######################################################################
# font procedures
######################################################################

proc jedit:font:roman { t } {
  jedit:set_tags $t richtext:font:roman
}

proc jedit:font:italic { t } {
  jedit:set_tags $t richtext:font:italic
}

proc jedit:font:bold { t } {
  jedit:set_tags $t richtext:font:bold
}

proc jedit:font:bolditalic { t } {
  jedit:set_tags $t richtext:font:bolditalic
}

proc jedit:font:typewriter { t } {
  jedit:set_tags $t richtext:font:typewriter
}

proc jedit:font:heading0 { t } {
  jedit:set_tags $t richtext:font:heading0
}

proc jedit:font:heading1 { t } {
  jedit:set_tags $t richtext:font:heading1
}

proc jedit:font:heading2 { t } {
  jedit:set_tags $t richtext:font:heading2
}

proc jedit:font:heading3 { t } {
  jedit:set_tags $t richtext:font:heading3
}

proc jedit:font:heading4 { t } {
  jedit:set_tags $t richtext:font:heading4
}

proc jedit:font:heading5 { t } {
  jedit:set_tags $t richtext:font:heading5
}

proc jedit:font:plain { t } {
  jedit:clear_tags $t richtext:font:*
}

######################################################################
# logical fonts for HTML
######################################################################

proc jedit:font:l_em { t } {
  jedit:set_tags $t richtext:font:l_em
}

proc jedit:font:l_cite { t } {
  jedit:set_tags $t richtext:font:l_cite
}

proc jedit:font:l_var { t } {
  jedit:set_tags $t richtext:font:l_var
}

proc jedit:font:l_dfn { t } {
  jedit:set_tags $t richtext:font:l_dfn
}

proc jedit:font:l_strong { t } {
  jedit:set_tags $t richtext:font:l_strong
}

proc jedit:font:l_kbd { t } {
  jedit:set_tags $t richtext:font:l_kbd
}

proc jedit:font:l_code { t } {
  jedit:set_tags $t richtext:font:l_code
}

proc jedit:font:l_samp { t } {
  jedit:set_tags $t richtext:font:l_samp
}

######################################################################
# other procedures
######################################################################

proc jedit:format:background { t colour } {
  jedit:set_tags $t display:background:$colour
}

proc jedit:format:foreground { t colour } {
  jedit:set_tags $t display:foreground:$colour
}

proc jedit:format:underline { t state } {
  if $state {
    jedit:set_tags $t display:underline:1
  } else {
    jedit:clear_tags $t display:underline:*
  }
}

proc jedit:format:background:clear { t } {
  jedit:clear_tags $t display:background:*
}

proc jedit:format:foreground:clear { t } {
  jedit:clear_tags $t display:foreground:*
}
