# jentryemacs.tcl - support for Emacs Entry bindings
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# j:eb:emacs_init - initialise info for Emacs Entry bindings
######################################################################

proc j:eb:emacs_init { e } {
  global j_teb
  set j_teb(cutbuffer) {}
  set j_teb(dragscroll,txnd) 0
  set j_teb(dragscroll,delay) 50
  set j_teb(scanpaste_time) 0
  set j_teb(scanpaste_paste) 1
    
  set j_teb(keymap,$e) emacs-normal
  
  j:eb:key_bind $e
  j:eb:mouse_bind $e
  
  j:ekb:mkmap Entry emacs-normal emacs-normal {
    {Control-slash		j:eb:select_all}
    {Control-backslash		j:eb:clear_selection}
    
    {Delete			j:ekb:delete_left}
    {BackSpace			j:ekb:delete_left}
    {Return			j:eb:no_op}
    
    {Left			j:ekb:left}
    {Right			j:ekb:right}
    
    {Home			j:ekb:bol}
    {End			j:ekb:eol}
    
    {Control-a			j:ekb:bol}
    {Control-e			j:ekb:eol}
    
    {Control-b			j:ekb:left}
    {Control-f			j:ekb:right}
    
    {Control-i			j:ekb:self_insert}
    {Control-j			j:ekb:self_insert}
    {Control-h			j:ekb:delete_left}
    
    {Control-d			j:ekb:delete_right}
    {Control-w			j:ekb:kill_selection}
    {Control-k			j:ekb:kill_eol}
    
    {Control-v			j:ekb:eol}
    
    {Control-q			j:ekb:new_mode emacs-literal}
    {Escape			j:ekb:new_mode emacs-escape}
    
    {Control-DEFAULT		j:eb:no_op}
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
  }
  
  j:ekb:mkmap Entry emacs-escape emacs-normal {
    {b				j:ekb:word_left}
    {f				j:ekb:word_right}
    {Delete			j:ekb:delete_left_word}
    {BackSpace			j:ekb:delete_left_word}
    {d				j:ekb:delete_right_word}
    {v				j:ekb:bol}
    {less			j:ekb:bol}
    {greater			j:ekb:eol}

    {Control-DEFAULT		j:eb:no_op}
    {DEFAULT			j:eb:no_op}
    {Shift-DEFAULT		j:eb:no_op}
  }
  
  j:ekb:mkmap Entry emacs-literal emacs-normal {
    {DEFAULT			j:ekb:self_insert}
    {Shift-DEFAULT		j:ekb:self_insert}
    {Control-DEFAULT		j:ekb:self_insert}
    {Meta-DEFAULT		j:ekb:self_insert}
  }
}

# deprecated alias for backward compatibility:

proc j:eb:emacs_bind { W } {
  j:eb:emacs_init $W
}
