# jformat.tcl - text tag-manipulation routines for jstools applications
#
######################################################################
# Copyright 1992-1997 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# font commands - these set the font (tag list) for typing.
#   also, if there is a selection, and the insertion point is in it
#   or abuts it, the selection is set to the specified font.
# NOTE: fonts are registered in jedit_cmds.tcl
######################################################################

######################################################################
# j:format:set_tags t tags - general routine to do the above for any tag
######################################################################

proc j:format:set_tags { t args } {
  foreach tag $args {
    j:tag:set_tag $t $tag
  }
  if {[j:text:insert_touches_selection $t]} {
    foreach tag $args {
      j:tag:tag_text $t $tag sel.first sel.last
    }
  }
}

######################################################################
# j:format:clear_tags t patterns - 
#   remove tags matching any pattern from tag list, and if appropriate,
#   from selection
######################################################################

proc j:format:clear_tags { t args } {
  foreach pattern $args {
    j:tag:clear_tag $t $pattern
  }
  if [j:text:insert_touches_selection $t] {
    foreach pattern $args {
      j:tag:untag_text $t $pattern sel.first sel.last
    }
  }
}

######################################################################
# font procedures
######################################################################

proc j:format:roman { t } {
  j:format:set_tags $t richtext:font:roman
}

proc j:format:italic { t } {
  j:format:set_tags $t richtext:font:italic
}

proc j:format:bold { t } {
  j:format:set_tags $t richtext:font:bold
}

proc j:format:bolditalic { t } {
  j:format:set_tags $t richtext:font:bolditalic
}

proc j:format:typewriter { t } {
  j:format:set_tags $t richtext:font:typewriter
}

proc j:format:heading0 { t } {
  j:format:set_tags $t richtext:font:heading0
}

proc j:format:heading1 { t } {
  j:format:set_tags $t richtext:font:heading1
}

proc j:format:heading2 { t } {
  j:format:set_tags $t richtext:font:heading2
}

proc j:format:heading3 { t } {
  j:format:set_tags $t richtext:font:heading3
}

proc j:format:heading4 { t } {
  j:format:set_tags $t richtext:font:heading4
}

proc j:format:heading5 { t } {
  j:format:set_tags $t richtext:font:heading5
}

proc j:format:plain { t } {
  j:format:clear_tags $t richtext:font:*
}

######################################################################
# logical fonts for HTML
######################################################################

proc j:format:l_em { t } {
  j:format:set_tags $t richtext:font:l_em
}

proc j:format:l_cite { t } {
  j:format:set_tags $t richtext:font:l_cite
}

proc j:format:l_var { t } {
  j:format:set_tags $t richtext:font:l_var
}

proc j:format:l_dfn { t } {
  j:format:set_tags $t richtext:font:l_dfn
}

proc j:format:l_strong { t } {
  j:format:set_tags $t richtext:font:l_strong
}

proc j:format:l_kbd { t } {
  j:format:set_tags $t richtext:font:l_kbd
}

proc j:format:l_code { t } {
  j:format:set_tags $t richtext:font:l_code
}

proc j:format:l_samp { t } {
  j:format:set_tags $t richtext:font:l_samp
}

######################################################################
# colours and underlining
######################################################################

proc j:format:background { t colour } {
  j:format:set_tags $t display:background:$colour
}

proc j:format:foreground { t colour } {
  j:format:set_tags $t display:foreground:$colour
}

proc j:format:underline { t state } {
  if $state {
    j:format:set_tags $t display:underline:1
  } else {
    j:format:clear_tags $t display:underline:*
  }
}

proc j:format:background:clear { t } {
  j:format:clear_tags $t display:background:*
}

proc j:format:foreground:clear { t } {
  j:format:clear_tags $t display:foreground:*
}

######################################################################
# commands for working with unordered lists
######################################################################

j:command:register j:format:list:start_ul {}
proc j:format:list:start_ul { t } {
  j:format:set_tags $t list:1:ul	;# the list at level 1 is unordered
  j:format:set_tags $t list:level:1	;# there's 1 list active
}

j:command:register j:format:list:end_ul {}
proc j:format:list:end_ul { t } {
  j:format:clear_tags $t list:*
}

proc j:format:list_item { t } {
  global j_tag
  
  # first see if we're already in a list, and if so at what level
  set tags $j_tag(tags,$t)
  set leveltagindex [lsearch -glob $tags list:level:*]
  if {$leveltagindex < 0} {
    # not already in a list; default to level 1
    j:format:set_tags $t list:1:ul	;# force being in a list
    j:format:set_tags $t list:level:1
    set level 1
  } else {
    # already in a list; use existing level
    set leveltag [lindex $tags $leveltagindex]
    set level [lindex [split $leveltag :] 2]
  }
  set start [$t index insert]
  j:text:insert_string $t "\xb7 "	;# 0xb7 is bullet in symbol font
  $t tag add special:list_item:$level $start
  
  $t tag configure special:list_item:$level -font \
    -*-symbol-*-*-*-*-*-120-*-*-*-*-*-*
  set textmargin [expr {$level * 8}]
  set itemmargin [expr {$textmargin - 4}]
  $t tag configure list:level:$level -relief raised -borderwidth $level
  catch {
    $t tag configure special:list_item:$level \
      -lmargin1 ${itemmargin}m -lmargin2 ${itemmargin}m
    $t tag configure list:level:$level \
      -lmargin1 ${textmargin}m -lmargin2 ${textmargin}m
  }
}

j:command:register j:format:list:nest_ul {}
proc j:format:list:nest_ul { t } {
  global j_tag
  
  # first see if we're already in a list, and if so at what level
  set tags $j_tag(tags,$t)
  set leveltagindex [lsearch -glob $tags list:level:*]
  if {$leveltagindex < 0} {
    # it's an error to use this when you're not already in a list
    j:beep $t
###     # not already in a list; default to level 1
###     j:format:set_tags $t list:1:ul	;# force being in a list
###     j:format:set_tags $t list:level:1
###     set level 1
  } else {
    # already in a list; increase level
    set leveltag [lindex $tags $leveltagindex]
    set level [lindex [split $leveltag :] 2]
    incr level
    j:format:set_tags $t list:$level:ul	;# the list at level 1 is unordered
    j:format:set_tags $t list:level:$level	;# how many nestings
    j:format:list_item $t
  }
}

j:command:register j:format:list:unnest {}
proc j:format:list:unnest { t } {
  global j_tag
  
  # first see if we're already in a list, and if so at what level
  set tags $j_tag(tags,$t)
  set leveltagindex [lsearch -glob $tags list:level:*]
  if {$leveltagindex < 0} {
    # it's an error to use this when you're not already in a list
    j:beep $t
  } else {
    # already in a list; use existing level
    set leveltag [lindex $tags $leveltagindex]
    set level [lindex [split $leveltag :] 2]
    j:format:clear_tags $t list:$level:*	;# clear tags from old level
    incr level -1
    if {$level > 0} {
      j:format:set_tags $t list:level:$level	;# specify new level
    } else {
      j:format:clear_tags $t list:level:*
    }
  }
}
