# jinit.tcl - common application initialisation procedures
#
######################################################################
# Copyright 1992-1997 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

### TO DO
###   more configurability

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:jstools_init - common initialisation for jstools
######################################################################

proc j:jstools_init { {app jstools} } {
  global J_PREFS			;# user preferences
  
  global JSTOOLS_VERSION
  set JSTOOLS_VERSION {4.2/4.5}
  
  catch {tk colormodel . color}		;# colour even on a 2-bit display
  
  global tk_library
  global env
  
  if {![info exists env(USER)]} {
    if [info exists env(LOGNAME)] {
      set env(USER) $env(LOGNAME)
    } else {
      set env(USER) [file tail $env(HOME)]
    }
  }
  global NAME; set NAME $env(USER)
  global HOME; set HOME $env(HOME)
  
  j:tk3 {
    option add *Entry*Relief sunken startupFile
    option add *Entry*BorderWidth 2 startupFile
    option add *Listbox*Relief sunken startupFile
    option add *Listbox*BorderWidth 2 startupFile
    option add *Text*Relief sunken startupFile
    option add *Text*BorderWidth 2 startupFile
    option add *Scrollbar*Relief sunken startupFile
    option add *Scrollbar*BorderWidth 2 startupFile
  }
  option add *Checkbutton*Relief flat startupFile
  option add *Radiobutton*Relief flat startupFile
  
  j:wm_client				;# set client hostname
  j:wm_command				;# set client command string
  
  j:pref:create_global_prefs		;# set up standard global prefs
  j:read_global_prefs			;# read standard jstools preferences
  j:ldb:init jstools			;# read in language database for library
  j:pref:create_global_prefs		;# again with language set (inefficient)
  j:source_config jstoolsrc.tcl		;# read cross-application preferences
  catch {				;# read cross-application X defaults:
    option readfile [glob -nocomplain ~/.tk/jstools.ad] userDefault
  }
  if {"x$app" != "xjstools"} {		;# application-specific initialisation
    j:ldb:init $app			;# read in language database for app
    catch {				;# read application-specific X defaults:      option readfile [glob -nocomplain ~/.tk/$app.ad] userDefault
    }
    ###					;# could read preferences here?
  }
  
  # following use users prefs, bindings files:
  j:tb:init Text			;# uses prefs, ~/.tk/textbindings.tcl
  j:eb:init Entry			;# uses prefs, ~/.tk/entrybindings.tcl
  
  j:command:register j:cmd:prompt_tcl {Issue Tcl Command...}
  j:command:register j:cmd:prompt_unix {Issue Unix Command...}
  j:command:register j:cmd:global_pref_panel {Global Preferences...}
  
  j:command:register j:cmd:text_cut {Cut}
  j:command:register j:cmd:text_copy {Copy}
  j:command:register j:cmd:text_paste {Paste}
}


