# jrt2tty.tcl - testing for tag conversion to plain text

proc j:tc:plaintext:start { t } {
  # following should be preferences
  set width 72
  set fixedfont -*-courier-medium-r-normal--*-120-*
  set toplevel [j:new_toplevel .jtc]
  set ct $toplevel.t
  # highlightthickness and borderwidth MUST be 0
  text $ct -font $fixedfont -wrap word -width 72 \
    -highlightthickness 0 -borderwidth 0
  pack $ct
  
  # figure width of a single character
  $ct insert 1.0 0
  update idletasks
  set bbox [$ct bbox 1.0]
  set margin [lindex $bbox 0]
  set width [expr [lindex $bbox 2]]
  $ct delete 1.0 end
  j:winfo $ct set width $width
  j:winfo $ct set margin $margin
  
  $ct insert end [$t get 1.0 end]
  j:tag:set_annotation $ct [j:tag:get_annotation $t]
  foreach tag [$t tag names] {
    foreach config [$t tag configure $tag] {
      $ct tag configure $tag [lindex $config 0] [lindex $config 4]
    }
    $ct tag configure $tag -font $fixedfont
    # apply configuration
  }
  $ct mark set insert 1.0
  
  return $ct
}

proc j:tc:plaintext:end { ct } {
  destroy [winfo toplevel $ct]
}

proc j:tc:plaintext:getline { ct index } {
  # returns list, first element of which is text of line and second 
  #   element of which is index of first character after line (or {} at EOF)
  
  set result {}
  
  $ct yview $index
  update idletasks
  
  # highlightthickness and borderwidth MUST be 0
  set dlineinfo [$ct dlineinfo $index]
  set linemargin [lindex $dlineinfo 0]
  set linetop [lindex $dlineinfo 1]
  set linebottom [expr $linetop + [lindex $dlineinfo 3]]
  set lineend [expr $linemargin + [lindex $dlineinfo 2]]
  set firstindex [$ct index @$linemargin,$linetop]
  set lastindex [$ct index @0,$linebottom]
#   j:alert -text "
# linemargin $linemargin
# linetop $linetop
# firstindex $firstindex
# 
# lineend $lineend
# lastindex $lastindex
# text \"[$ct get $firstindex $lastindex]\"
# "
  set margin [j:winfo $ct get margin]
  set width [j:winfo $ct get width]
  set numspaces [expr {int((($linemargin - $margin) / $width) + 0.5)}]
  set line [$ct get $firstindex $lastindex]
  regsub -all -- \xb7 $line * line
  regsub -all -- \xad $line - line
  # should check for tabs, fonts, etc.
  append result [string range "                            " 1 $numspaces]
  append result $line
  $ct mark set insert $lastindex
  if [$ct compare $lastindex >= end-1c] {
    set lastindex {}
  }
  return [list $lastindex $result]
}

proc j:tc:plaintext:get { t } {
  set ct [j:tc:plaintext:start $t]
  
  set result {}
  set index 1.0
  while 1 {
    set linedata [j:tc:plaintext:getline $ct $index]
    append result [lindex $linedata 1]\n
    regsub -all \n\n\n* $result \n\n result
    set index [lindex $linedata 0]
    if [string match {} $index] {
      j:tc:plaintext:end $ct
      break
    }
  }
  return $result
}
